/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.filter;

import com.klikli_dev.theurgy.content.behaviour.filter.Filter;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class ListFilter
extends Filter {
    protected List<ItemStack> filterItems;
    protected List<FluidStack> filterFluids;
    protected boolean shouldRespectDataComponents;
    protected boolean isDenyList;

    protected ListFilter(HolderLookup.Provider provider, ItemStack filter) {
        super(provider, filter);
    }

    public List<ItemStack> filterItems() {
        return this.filterItems;
    }

    public List<FluidStack> filterFluids() {
        return this.filterFluids;
    }

    public boolean shouldRespectDataComponents() {
        return this.shouldRespectDataComponents;
    }

    public boolean isDenyList() {
        return this.isDenyList;
    }

    @Override
    protected void initFromFilterItemStack(HolderLookup.Provider provider, ItemStack filterItemStack) {
        this.filterItems = this.getFilterItems(filterItemStack);
        this.shouldRespectDataComponents = (Boolean)filterItemStack.getOrDefault(DataComponentRegistry.FILTER_RESPECTS_DATA_COMPONENTS, (Object)false);
        this.isDenyList = (Boolean)filterItemStack.getOrDefault(DataComponentRegistry.FILTER_IS_DENY_LIST, (Object)false);
    }

    @Override
    public boolean test(Level world, ItemStack stack, boolean matchDataComponents) {
        for (ItemStack filterItemStack : this.filterItems) {
            if (!this.testFilterItemStack(filterItemStack, stack, this.shouldRespectDataComponents)) continue;
            return !this.isDenyList;
        }
        return this.isDenyList;
    }

    @Override
    public boolean test(Level level, FluidStack stack, boolean matchDataComponents) {
        this.resolveFluids();
        for (FluidStack filterFluidStack : this.filterFluids) {
            if (!this.testFilterFluidStack(filterFluidStack, stack, this.shouldRespectDataComponents)) continue;
            return !this.isDenyList;
        }
        return this.isDenyList;
    }

    private void resolveFluids() {
        if (this.filterFluids != null) {
            return;
        }
        this.filterFluids = new ArrayList<FluidStack>();
        for (ItemStack filterItem : this.filterItems) {
            IFluidHandlerItem capability = (IFluidHandlerItem)filterItem.getCapability(Capabilities.FluidHandler.ITEM);
            if (capability == null) continue;
            this.filterFluids.add(capability.getFluidInTank(0).copyWithAmount(1));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.filterItems.isEmpty();
    }

    private boolean testFilterItemStack(ItemStack filterItemStack, ItemStack stackToTest, boolean matchDataComponents) {
        if (matchDataComponents) {
            return ItemStack.isSameItemSameComponents((ItemStack)filterItemStack, (ItemStack)stackToTest);
        }
        return ItemStack.isSameItem((ItemStack)filterItemStack, (ItemStack)stackToTest);
    }

    private boolean testFilterFluidStack(FluidStack filterFluidStack, FluidStack stackToTest, boolean matchDataComponents) {
        if (matchDataComponents) {
            return FluidStack.matches((FluidStack)filterFluidStack, (FluidStack)stackToTest);
        }
        return FluidStack.isSameFluid((FluidStack)filterFluidStack, (FluidStack)stackToTest);
    }

    private List<ItemStack> getFilterItems(ItemStack filter) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!filter.has(DataComponentRegistry.FILTER_ITEMS)) {
            return result;
        }
        ItemContainerContents items = (ItemContainerContents)filter.get(DataComponentRegistry.FILTER_ITEMS);
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            result.add(stackInSlot);
        }
        return result;
    }
}

