/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.fermentationvat;

import com.klikli_dev.theurgy.content.apparatus.fermentationvat.FermentationCachedCheck;
import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.FermentationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class FermentationCraftingBehaviour
extends CraftingBehaviour<ItemHandlerWithFluidRecipeInput, FermentationRecipe, FermentationCachedCheck> {
    protected Supplier<IFluidHandler> fluidTankSupplier;

    public FermentationCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<IFluidHandler> fluidTankSupplier) {
        super(blockEntity, Lazy.of(() -> new ItemHandlerWithFluidRecipeInput((IItemHandlerModifiable)inputInventorySupplier.get(), (IFluidHandler)fluidTankSupplier.get())), inputInventorySupplier, outputInventorySupplier, new FermentationCachedCheck((RecipeType<FermentationRecipe>)((RecipeType)RecipeTypeRegistry.FERMENTATION.get())));
        this.fluidTankSupplier = fluidTankSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (this.alreadyHasInput(stack)) {
            return true;
        }
        Optional currentRecipe = this.getRecipe();
        if (currentRecipe.isPresent()) {
            return ((FermentationRecipe)currentRecipe.get().value()).getIngredients().stream().anyMatch(ingredient -> ingredient.test(stack));
        }
        List<ItemStack> ingredientsList = Stream.concat(IntStream.range(0, ((IItemHandlerModifiable)this.inputInventorySupplier.get()).getSlots()).filter(i -> !((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(i).isEmpty()).mapToObj(i -> ((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(i)), Stream.of(stack)).toList();
        if (ingredientsList.size() > 1) {
            return ((FermentationCachedCheck)this.recipeCachedCheck).getRecipeFor(ingredientsList, this.blockEntity.getLevel()).isPresent();
        }
        return this.isIngredient(stack);
    }

    public void onInputChanged() {
        ((FermentationCachedCheck)this.recipeCachedCheck).resetNoRecipeForLastItemHandlerInput();
    }

    @Override
    public boolean isIngredient(ItemStack stack) {
        return ((FermentationCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.getLevel()).isPresent();
    }

    @Override
    public boolean canProcess(FluidStack stack) {
        if (FluidStack.isSameFluidSameComponents((FluidStack)this.fluidTankSupplier.get().getFluidInTank(0), (FluidStack)stack)) {
            return true;
        }
        return this.isIngredient(stack);
    }

    @Override
    public boolean isIngredient(FluidStack stack) {
        return ((FermentationCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.getLevel()).isPresent();
    }

    @Override
    protected int getIngredientCount(RecipeHolder<FermentationRecipe> recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(RecipeHolder<FermentationRecipe> recipe) {
        return ((FermentationRecipe)recipe.value()).getTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 200;
    }

    @Override
    protected boolean craft(RecipeHolder<FermentationRecipe> pRecipe) {
        ItemStack assembledStack = ((FermentationRecipe)pRecipe.value()).assemble((ItemHandlerWithFluidRecipeInput)this.recipeInputSupplier.get(), (HolderLookup.Provider)this.blockEntity.getLevel().registryAccess());
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        block0: for (Ingredient ingredient : ((FermentationRecipe)pRecipe.value()).getIngredients()) {
            for (int i = 0; i < ((IItemHandlerModifiable)this.inputInventorySupplier.get()).getSlots(); ++i) {
                if (!ingredient.test(((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(i))) continue;
                ((IItemHandlerModifiable)this.inputInventorySupplier.get()).extractItem(i, this.getIngredientCount(pRecipe), false);
                continue block0;
            }
        }
        this.fluidTankSupplier.get().drain(((FermentationRecipe)pRecipe.value()).getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

