/*
 * Decompiled with CFR 0.152.
 */
package mcjty.restrictions.items;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.items.GenericArmorItem;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.restrictions.Restrictions;
import mcjty.restrictions.items.GlassBootsModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class GlassBoots
extends GenericArmorItem
implements ITooltipSettings {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.restrictions.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public GlassBoots() {
        super(ArmorMaterials.LEATHER, EquipmentSlot.FEET, Restrictions.setup.defaultProperties());
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext pContext, List<Component> list, TooltipFlag flags) {
        super.appendHoverText(itemStack, pContext, list, flags);
        this.tooltipBuilder.makeTooltip(BuiltInRegistries.ITEM.getKey((Object)this), itemStack, list, flags);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"restrictions", (String)"textures/item/textureboots.png");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            @Nonnull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return GlassBootsModel.getModel(livingEntity, itemStack);
            }
        });
    }
}

