/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.IClientHighlightHandler;
import net.p3pp3rf1y.sophisticatedcore.client.render.ItemInStorageHighlightRenderer;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.MovingStorageItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;

public class MovingStorageHighlightHandler
implements IClientHighlightHandler<List<Integer>> {
    public static final MovingStorageHighlightHandler INSTANCE = new MovingStorageHighlightHandler();
    private List<Integer> highlightedStackEntityIds = Collections.emptyList();
    private List<Integer> highlightedItemEntityIds = Collections.emptyList();

    private MovingStorageHighlightHandler() {
    }

    public void setHighlightedEntities(List<Integer> stackEntityIds, List<Integer> itemEntityIds) {
        this.highlightedStackEntityIds = stackEntityIds;
        this.highlightedItemEntityIds = itemEntityIds;
    }

    public ResourceLocation getPayloadHandlerId() {
        return MovingStorageItemActionPayloadHandler.ID;
    }

    public Optional<List<Integer>> buildClientRequestData(Player player) {
        List<Integer> entityIds = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(32.0), e -> e instanceof IMovingStorageEntity && e.distanceTo((Entity)player) <= 32.0f).stream().map(Entity::getId).toList();
        return entityIds.isEmpty() ? Optional.empty() : Optional.of(entityIds);
    }

    public void clearCache() {
        this.highlightedStackEntityIds = Collections.emptyList();
        this.highlightedItemEntityIds = Collections.emptyList();
    }

    public void render(PoseStack poseStack, float partialTick, Vec3 cameraPos) {
        this.highlightedStackEntityIds.forEach(eId -> MovingStorageHighlightHandler.renderHighlightedEntity(poseStack, partialTick, cameraPos, eId, Minecraft.getInstance(), Minecraft.getInstance().renderBuffers().bufferSource(), 5025616));
        this.highlightedItemEntityIds.forEach(eId -> MovingStorageHighlightHandler.renderHighlightedEntity(poseStack, partialTick, cameraPos, eId, Minecraft.getInstance(), Minecraft.getInstance().renderBuffers().bufferSource(), 4367861));
    }

    private static void renderHighlightedEntity(PoseStack poseStack, float partialTick, Vec3 cameraPos, int entityId, Minecraft mc, MultiBufferSource.BufferSource buffer, int color) {
        Entity entity = mc.level.getEntity(entityId);
        if (entity == null) {
            return;
        }
        AABB boundingBox = entity.getBoundingBox();
        double x = Mth.lerp((double)partialTick, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)partialTick, (double)entity.yOld, (double)entity.getY());
        double z = Mth.lerp((double)partialTick, (double)entity.zOld, (double)entity.getZ());
        poseStack.pushPose();
        double halfH = boundingBox.getYsize() * 0.5;
        poseStack.translate(x - cameraPos.x(), y - cameraPos.y(), z - cameraPos.z());
        poseStack.translate(0.0, halfH, 0.0);
        float scale = 1.0f + Easing.EASE_IN_OUT_CUBIC.ease((float)ItemInStorageHighlightRenderer.tri01((double)mc.level.getGameTime(), (double)15.0, (double)partialTick)) * 0.05f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0, -halfH, 0.0);
        BlockHighlightRenderHelper.renderThickEdges((PoseStack)poseStack, (MultiBufferSource)buffer, (int)color, (List)VoxelOutliner.edgesFromAABB((AABB)boundingBox), (double)entity.getX(), (double)entity.getY(), (double)entity.getZ());
        poseStack.popPose();
    }
}

