/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.setup.registry;

import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="allthearcanistgear", bus=EventBusSubscriber.Bus.MOD)
public class AddonAttributeRegistry {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"allthearcanistgear");
    public static final DeferredHolder<Attribute, Attribute> SPECTRAL_SIGHT = AddonAttributeRegistry.registerAttribute("allthearcanistgear.spectral_sight", id -> new RangedAttribute(id, 0.0, 0.0, 64.0).setSyncable(true));

    public static DeferredHolder<Attribute, Attribute> registerAttribute(String name, Function<String, Attribute> attribute) {
        return ATTRIBUTES.register(name, () -> (Attribute)attribute.apply(name));
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
        for (EntityType type : event.getTypes()) {
            if (type != EntityType.PLAYER) continue;
            for (DeferredHolder attribute : ATTRIBUTES.getEntries()) {
                event.add(type, (Holder)attribute);
            }
        }
    }
}

