/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators.TYGTreeDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class AttachedToLogsDecorator
extends TreeDecorator {
    public static final MapCodec<AttachedToLogsDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(attachedToLogsDecorator -> Float.valueOf(attachedToLogsDecorator.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.exclusionRadiusY), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.blockProvider), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.requiredEmptyBlocks), (App)ExtraCodecs.nonEmptyList((Codec)Direction.CODEC.listOf()).fieldOf("directions").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.directions)).apply((Applicative)builder, AttachedToLogsDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int exclusionRadiusY;
    protected final BlockStateProvider blockProvider;
    protected final int requiredEmptyBlocks;
    protected final List<Direction> directions;

    public AttachedToLogsDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, BlockStateProvider blockProvider, int requiredEmptyBlocks, List<Direction> directions) {
        this.probability = probability;
        this.exclusionRadiusXZ = exclusionRadiusXZ;
        this.exclusionRadiusY = exclusionRadiusY;
        this.blockProvider = blockProvider;
        this.requiredEmptyBlocks = requiredEmptyBlocks;
        this.directions = directions;
    }

    public void place(TreeDecorator.Context pContext) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        RandomSource randomsource = pContext.random();
        for (BlockPos blockpos : Util.shuffledCopy((ObjectArrayList)pContext.logs(), (RandomSource)randomsource)) {
            Direction direction;
            BlockPos relative = blockpos.relative(direction = (Direction)Util.getRandom(this.directions, (RandomSource)randomsource));
            if (set.contains(relative) || !(randomsource.nextFloat() < this.probability) || !this.hasRequiredEmptyBlocks(pContext, blockpos, direction)) continue;
            BlockPos offsetMin = relative.offset(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPos offsetMax = relative.offset(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPos blockpos4 : BlockPos.betweenClosed((BlockPos)offsetMin, (BlockPos)offsetMax)) {
                set.add(blockpos4.immutable());
            }
            BlockState state = this.blockProvider.getState(randomsource, relative);
            if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction);
            }
            pContext.setBlock(relative, state);
        }
    }

    private boolean hasRequiredEmptyBlocks(TreeDecorator.Context pContext, BlockPos pPos, Direction pDirection) {
        for (int i = 1; i <= this.requiredEmptyBlocks; ++i) {
            BlockPos blockpos = pPos.relative(pDirection, i);
            if (pContext.isAir(blockpos)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected TreeDecoratorType<?> type() {
        return TYGTreeDecoratorTypes.ATTACHED_TO_LOGS.get();
    }
}

