/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.mixin;

import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedInputPatternState;
import com.ultramega.cabletiers.common.mixin.InvokerPatternTooltipCache;
import com.ultramega.cabletiers.common.utils.SidedInput;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternItem.class})
public final class MixinPatternItem {
    @Unique
    private static final Map<UUID, Boolean> SENT_SIDED_RESOURCES_DATA = new HashMap<UUID, Boolean>();

    @Inject(method={"getTooltipImage"}, at={@At(value="HEAD")})
    public void getTooltipImage(ItemStack stack, CallbackInfoReturnable<Optional<TooltipComponent>> cir) {
        ClientTooltipComponent clientTooltipComponent;
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (state == null || SENT_SIDED_RESOURCES_DATA.computeIfAbsent(state.id(), uuid -> false).booleanValue()) {
            return;
        }
        Level level = ClientPlatformUtil.getClientLevel();
        if (level == null) {
            return;
        }
        SidedInputPatternState sidedInputState = (SidedInputPatternState)stack.get(com.ultramega.cabletiers.common.registry.DataComponents.INSTANCE.getSidedInputPatternState());
        if (sidedInputState == null) {
            return;
        }
        if (state.type() == PatternType.PROCESSING && (clientTooltipComponent = InvokerPatternTooltipCache.getCache().get(state.id())) instanceof SidedInput) {
            SidedInput sidedInput = (SidedInput)clientTooltipComponent;
            sidedInput.cabletiers$setSidedResources(sidedInputState.sidedResources());
            SENT_SIDED_RESOURCES_DATA.put(state.id(), true);
        }
    }
}

