/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;

public class UpdateWorldSharedTankClientCachePacket
extends PacketCodec<UpdateWorldSharedTankClientCachePacket> {
    public static final CustomPacketPayload.Type<UpdateWorldSharedTankClientCachePacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"update_world_shared_tank_client_cache"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateWorldSharedTankClientCachePacket> CODEC = UpdateWorldSharedTankClientCachePacket.getCodec(UpdateWorldSharedTankClientCachePacket::new);
    @CodecField
    private String tankID = null;
    @CodecField
    private FluidStack fluidStack = null;

    public UpdateWorldSharedTankClientCachePacket() {
        super(ID);
    }

    public boolean isAsync() {
        return true;
    }

    public UpdateWorldSharedTankClientCachePacket(String tankID, FluidStack fluidStack) {
        super(ID);
        this.tankID = tankID;
        this.fluidStack = fluidStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        WorldSharedTankCache.getInstance().setTankContent(this.tankID, this.fluidStack);
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

