/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;

@GameTestHolder(value="evilcraft")
@PrefixGameTestTemplate(value=false)
public class GameTestsItemEternalWater {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10")
    public void testItemEternalWaterPlaceWorld(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(helper.absolutePos(POS).getCenter());
        player.setXRot(90.0f);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ETERNAL_WATER);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.setBlock(POS.north(), Blocks.STONE);
        helper.setBlock(POS.east(), Blocks.STONE);
        helper.setBlock(POS.south(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.STONE);
        InteractionResultHolder result = itemStack.use((Level)helper.getLevel(), player, InteractionHand.MAIN_HAND);
        helper.succeedWhen(() -> {
            helper.assertTrue(result.getResult() == InteractionResult.SUCCESS, "Result is not successful");
            helper.assertFalse(((ItemStack)result.getObject()).isEmpty(), "Result is empty");
            helper.assertTrue(((ItemStack)result.getObject()).getItem() == RegistryEntries.ITEM_ETERNAL_WATER.get(), "Result item is incorrect");
            helper.assertBlockPresent(Blocks.WATER, POS);
            helper.assertFalse(player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty(), "Item in hand is empty");
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == RegistryEntries.ITEM_ETERNAL_WATER.get(), "Item in hand is incorrect");
        });
    }

    @GameTest(template="empty10")
    public void testItemEternalWaterPickupWorld(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(helper.absolutePos(POS).getCenter());
        player.setXRot(90.0f);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ETERNAL_WATER);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.setBlock(POS.north(), Blocks.STONE);
        helper.setBlock(POS.east(), Blocks.STONE);
        helper.setBlock(POS.south(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.STONE);
        helper.setBlock(POS, Blocks.WATER);
        InteractionResultHolder result = itemStack.use((Level)helper.getLevel(), player, InteractionHand.MAIN_HAND);
        helper.succeedWhen(() -> {
            helper.assertTrue(result.getResult() == InteractionResult.SUCCESS, "Result is not successful");
            helper.assertFalse(((ItemStack)result.getObject()).isEmpty(), "Result is empty");
            helper.assertTrue(((ItemStack)result.getObject()).getItem() == RegistryEntries.ITEM_ETERNAL_WATER.get(), "Result item is incorrect");
            helper.assertBlockNotPresent(Blocks.WATER, POS);
            helper.assertFalse(player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty(), "Item in hand is empty");
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == RegistryEntries.ITEM_ETERNAL_WATER.get(), "Item in hand is incorrect");
        });
    }

    @GameTest(template="empty10")
    public void testItemEternalWaterFillTank(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ETERNAL_WATER);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_DARK_TANK.get());
        InteractionResult result = itemStack.onItemUseFirst(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.succeedWhen(() -> {
            helper.assertTrue(result == InteractionResult.SUCCESS, "Result is not successful");
            BlockEntityDarkTank tank = (BlockEntityDarkTank)helper.getBlockEntity(POS);
            helper.assertTrue(FluidStack.matches((FluidStack)tank.getTank().getFluid(), (FluidStack)new FluidStack((Fluid)Fluids.WATER, 1000)), "Fluid in tank is incorrect");
            helper.assertFalse(player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty(), "Item in hand is empty");
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == RegistryEntries.ITEM_ETERNAL_WATER.get(), "Item in hand is incorrect");
        });
    }

    @GameTest(template="empty10")
    public void testItemEternalWaterFillCauldron(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ETERNAL_WATER);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.setBlock(POS, Blocks.CAULDRON);
        InteractionResult result = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.succeedWhen(() -> {
            helper.assertTrue(result == InteractionResult.SUCCESS, "Result is not successful");
            helper.assertBlockPresent(Blocks.WATER_CAULDRON, POS);
            helper.assertBlockProperty(POS, (Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
            helper.assertFalse(player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty(), "Item in hand is empty");
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == RegistryEntries.ITEM_ETERNAL_WATER.get(), "Item in hand is incorrect");
        });
    }

    @GameTest(template="empty10")
    public void testItemEternalWaterFillCauldronPartial(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ETERNAL_WATER);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.setBlock(POS, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(1)));
        InteractionResult result = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(helper.absolutePos(POS).getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.succeedWhen(() -> {
            helper.assertTrue(result == InteractionResult.SUCCESS, "Result is not successful");
            helper.assertBlockPresent(Blocks.WATER_CAULDRON, POS);
            helper.assertBlockProperty(POS, (Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
            helper.assertFalse(player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty(), "Item in hand is empty");
            helper.assertTrue(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == RegistryEntries.ITEM_ETERNAL_WATER.get(), "Item in hand is incorrect");
        });
    }
}

