/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodChest;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;

@GameTestHolder(value="evilcraft")
@PrefixGameTestTemplate(value=false)
public class GameTestsBloodChest {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10")
    public void testBloodChestRepair(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_CHEST.get());
        BlockEntityBloodChest chest = (BlockEntityBloodChest)helper.getBlockEntity(POS);
        ItemStack sword = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
        sword.set(DataComponents.DAMAGE, (Object)10);
        chest.getInventory().setItem(0, sword);
        chest.getInventory().setItem(11, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_DARK_TANK.get());
        BlockEntityDarkTank tank = (BlockEntityDarkTank)helper.getBlockEntity(POS.above());
        tank.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 8000));
        tank.setEnabled(true);
        helper.succeedWhen(() -> helper.assertValueEqual((Object)chest.getInventory().getItem(0).getDamageValue(), (Object)0, "Sword has not been repaired"));
    }
}

