/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import org.cyclops.evilcraft.RegistryEntries;

public class RecipeDeadBush
extends CustomRecipe {
    public RecipeDeadBush(CraftingBookCategory category) {
        super(category);
    }

    public boolean isSpecial() {
        return false;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        int bushes = 0;
        int shears = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemStack = inv.getItem(i);
            if (itemStack.is(ItemTags.SAPLINGS)) {
                ++bushes;
                continue;
            }
            if (!itemStack.is(Tags.Items.TOOLS_SHEAR)) continue;
            ++shears;
        }
        return bushes == 1 && shears == 1;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        return this.getResultItem(registryAccess).copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return new ItemStack((ItemLike)Items.DEAD_BUSH);
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((TagKey)ItemTags.SAPLINGS), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR)});
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height == 2;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList stacks = NonNullList.create();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemStack = inv.getItem(i);
            if (itemStack.getItem() == Items.SHEARS) {
                itemStack = itemStack.copy();
                Player craftingPlayer = CommonHooks.getCraftingPlayer();
                if (craftingPlayer != null) {
                    itemStack.hurtAndBreak(1, (LivingEntity)craftingPlayer, EquipmentSlot.MAINHAND);
                } else if (itemStack.getDamageValue() + 1 > itemStack.getMaxDamage()) {
                    itemStack.shrink(1);
                } else {
                    itemStack.setDamageValue(itemStack.getDamageValue() + 1);
                }
            } else {
                itemStack = CommonHooks.getCraftingRemainingItem((ItemStack)itemStack);
            }
            stacks.add((Object)itemStack);
        }
        return stacks;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_DEAD_BUSH.get();
    }
}

