/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;

@OnlyIn(value=Dist.CLIENT)
public class ParticleBloodBubble
extends WaterDropParticle {
    public ParticleBloodBubble(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.gravity = 0.04f;
        if (ySpeedIn == 0.0 && (xSpeedIn != 0.0 || zSpeedIn != 0.0)) {
            this.xd = xSpeedIn;
            this.yd = 0.1;
            this.zd = zSpeedIn;
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd += 0.002;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.85;
        this.yd *= 0.85;
        this.zd *= 0.85;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void randomDisplayTick(@Nullable BlockEntityWorking tile, Level world, BlockPos blockPos, RandomSource random, Direction rotatedDirection) {
        if (tile != null && random.nextInt(10) == 0 && tile.isVisuallyWorking()) {
            for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                double particleX = (double)(blockPos.getX() - rotatedDirection.getStepX() + (rotatedDirection == Direction.EAST ? 1 : 0)) + (rotatedDirection == Direction.NORTH || rotatedDirection == Direction.SOUTH ? 0.3 + random.nextDouble() * 0.4 : 0.0);
                double particleY = (double)blockPos.getY() + 0.1 + random.nextDouble() * 0.5;
                double particleZ = (double)(blockPos.getZ() - rotatedDirection.getStepZ() + (rotatedDirection == Direction.SOUTH ? 1 : 0)) + (rotatedDirection == Direction.EAST || rotatedDirection == Direction.WEST ? 0.3 + random.nextDouble() * 0.4 : 0.0);
                float particlemotionX = -0.1f + random.nextFloat() * 0.2f;
                float particlemotionY = 0.01f;
                float particlemotionZ = -0.1f + random.nextFloat() * 0.2f;
                Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)RegistryEntries.PARTICLE_BLOOD_BUBBLE.get(), false, particleX, particleY, particleZ, (double)particlemotionX, (double)particlemotionY, (double)particlemotionZ);
            }
        }
    }
}

