/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodchest;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairAction;
import org.cyclops.evilcraft.block.BlockBloodChestConfig;

public class DamageableItemRepairAction
implements IBloodChestRepairAction {
    @Override
    public boolean isItemValidForSlot(ItemStack itemStack) {
        return itemStack.isDamageableItem();
    }

    @Override
    public boolean canRepair(ItemStack itemStack, int tick) {
        return itemStack.isDamaged();
    }

    @Override
    public Pair<Float, ItemStack> repair(ItemStack itemStack, RandomSource random, boolean doAction, boolean isBulk, HolderLookup.Provider holderLookupProvider) {
        if (doAction) {
            int newDamage = itemStack.getDamageValue() - 1;
            itemStack.setDamageValue(newDamage);
            if (!isBulk && BlockBloodChestConfig.addRandomBadEnchants && BlockBloodChestConfig.randomBadEnchantsChance >= 0 && random.nextInt(BlockBloodChestConfig.randomBadEnchantsChance) == 0) {
                List<Holder.Reference> curses = holderLookupProvider.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(p_344414_ -> p_344414_.is(EnchantmentTags.CURSE)).toList();
                Holder enchantment = (Holder)curses.get(random.nextInt(curses.size()));
                itemStack.enchant(enchantment, ((Enchantment)enchantment.value()).getMinLevel() + random.nextInt(((Enchantment)enchantment.value()).getMaxLevel() - ((Enchantment)enchantment.value()).getMinLevel() + 1) - 1);
            }
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)itemStack);
    }
}

