/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.HollowCubeDetector;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.MaximumBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.MinimumSizeValidator;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.spiritfurnace.BoxCookTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritFurnace;

public class BlockEntitySpiritFurnace
extends BlockEntityWorking<BlockEntitySpiritFurnace, MutableDouble>
implements MenuProvider {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int[] SLOTS_DROP = new int[]{2, 3, 4, 5};
    public static final int SLOTS = 2 + SLOTS_DROP.length;
    public static Metadata METADATA = new Metadata();
    public static final int LIQUID_PER_SLOT = 10000;
    protected static final MinimumSizeValidator minimumSizeValidator = new MinimumSizeValidator(new Vec3i(2, 2, 2));
    private static CubeDetector detector;
    private static final Map<Class<?>, ITickAction<BlockEntitySpiritFurnace>> BOX_COOK_TICK_ACTIONS;
    private static final Map<Class<?>, ITickAction<BlockEntitySpiritFurnace>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    @NBTPersist(useDefaultValue=false)
    private Vec3i size = LocationHelpers.copyLocation((Vec3i)Vec3i.ZERO);
    @NBTPersist
    private Boolean forceHalt = false;
    @NBTPersist
    private Boolean caughtError = false;
    private int cookTicker = this.addTicker(new TickComponent<BlockEntitySpiritFurnace, ITickAction<BlockEntitySpiritFurnace>>(this, BOX_COOK_TICK_ACTIONS, 1, true, false));
    private Entity boxEntityCache = null;

    public BlockEntitySpiritFurnace(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SPIRIT_FURNACE.get(), blockPos, blockState, SLOTS, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD.get());
        this.addTicker(new TickComponent<BlockEntitySpiritFurnace, ITickAction<BlockEntitySpiritFurnace>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<BlockEntitySpiritFurnace, MutableDouble>(this, 1.0){

            @Override
            public void applyUpgrade(BlockEntitySpiritFurnace upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<BlockEntitySpiritFurnace, MutableDouble>(this, 2.0){

            @Override
            public void applyUpgrade(BlockEntitySpiritFurnace upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    public static CubeDetector getCubeDetector() {
        if (detector == null) {
            detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((Block)RegistryEntries.BLOCK_DARK_BLOOD_BRICK.get()), new AllowedBlock((Block)RegistryEntries.BLOCK_SPIRIT_FURNACE.get()).addCountValidator((IBlockCountValidator)new MaximumBlockCountValidator(1))}, (List)Lists.newArrayList((Object[])new Block[]{(Block)RegistryEntries.BLOCK_SPIRIT_FURNACE.get(), (Block)RegistryEntries.BLOCK_DARK_BLOOD_BRICK.get()})).addSizeValidator((ISizeValidator)minimumSizeValidator);
        }
        return detector;
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new BlockEntityWorking.Inventory<BlockEntitySpiritFurnace>(inventorySize, stackSize, this){

            @Override
            public boolean canPlaceItem(int slot, ItemStack itemStack) {
                if (slot == 1) {
                    return BlockEntitySpiritFurnace.this.getTileWorkingMetadata().canConsume(itemStack, BlockEntitySpiritFurnace.this.getLevel());
                }
                if (slot == 0) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)((Fluid)RegistryEntries.FLUID_BLOOD.get()));
                }
                return super.canPlaceItem(slot, itemStack);
            }

            public boolean canPlaceItemThroughFace(int slot, ItemStack itemStack, Direction side) {
                return slot < 2 && super.canPlaceItemThroughFace(slot, itemStack, side);
            }

            public boolean canTakeItemThroughFace(int slot, ItemStack itemStack, Direction side) {
                return slot >= 2 && super.canTakeItemThroughFace(slot, itemStack, side);
            }
        };
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.cookTicker;
    }

    public Entity getEntity() {
        EntityType<?> id;
        ItemStack boxStack = this.getInventory().getItem(this.getConsumeSlot());
        if (!boxStack.isEmpty() && boxStack.getItem() == BlockEntitySpiritFurnace.getAllowedCookItem() && (id = BlockBoxOfEternalClosure.getSpiritTypeWithFallbackSpirit(boxStack)) != null && id != RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get()) {
            Entity entity;
            if (this.boxEntityCache != null && id == this.boxEntityCache.getType()) {
                return this.boxEntityCache;
            }
            this.boxEntityCache = entity = id.create(this.level);
            return entity;
        }
        return null;
    }

    public String getPlayerId() {
        ItemStack boxStack = this.getInventory().getItem(this.getConsumeSlot());
        if (!boxStack.isEmpty() && boxStack.getItem() == BlockEntitySpiritFurnace.getAllowedCookItem()) {
            return BlockBoxOfEternalClosure.getPlayerId(boxStack);
        }
        return "";
    }

    public String getPlayerName() {
        ItemStack boxStack = this.getInventory().getItem(this.getConsumeSlot());
        if (!boxStack.isEmpty() && boxStack.getItem() == BlockEntitySpiritFurnace.getAllowedCookItem()) {
            return BlockBoxOfEternalClosure.getPlayerName(boxStack);
        }
        return "";
    }

    public boolean isPlayer() {
        return !this.getPlayerId().isEmpty();
    }

    public Vec3i getEntitySize() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return Vec3i.ZERO;
        }
        return EntityHelpers.getEntitySize((Entity)entity);
    }

    public boolean isSizeValidForEntity() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        Vec3i requiredSize = this.getEntitySize();
        return this.getInnerSize().compareTo(requiredSize) >= 0;
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        Vec3i size = this.getSize();
        return size.compareTo(minimumSizeValidator.getMinimumSize()) >= 0;
    }

    public static boolean canWork(Level world, BlockPos location) {
        BlockEntity tile = world.getBlockEntity(location);
        if (tile != null) {
            return ((BlockEntitySpiritFurnace)tile).canWork();
        }
        return false;
    }

    public static Item getAllowedCookItem() {
        return (Item)RegistryEntries.ITEM_BOX_OF_ETERNAL_CLOSURE.get();
    }

    public static void detectStructure(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
    }

    public int getConsumeSlot() {
        return 1;
    }

    public int[] getProduceSlots() {
        return SLOTS_DROP;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public Vec3i getInnerSize() {
        return LocationHelpers.subtract((Vec3i)this.getSize(), (Vec3i)new Vec3i(1, 1, 1));
    }

    public void setSize(Vec3i size) {
        this.size = size;
        this.sendUpdate();
    }

    public void onItemDrop(ItemStack itemStack) {
        boolean placed = false;
        int[] slots = this.getProduceSlots();
        for (int i = 0; !placed && i < slots.length; ++i) {
            ItemStack produceStack = this.getInventory().getItem(slots[i]);
            if (produceStack.isEmpty()) {
                this.getInventory().setItem(slots[i], itemStack);
                placed = true;
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)produceStack, (ItemStack)itemStack) || produceStack.getMaxStackSize() < produceStack.getCount() + itemStack.getCount()) continue;
            produceStack.grow(itemStack.getCount());
            placed = true;
        }
        this.forceHalt = !placed;
    }

    @Override
    public void resetWork(boolean hardReset) {
        this.forceHalt = false;
        this.caughtError = false;
        super.resetWork(hardReset);
    }

    public boolean isForceHalt() {
        return this.forceHalt;
    }

    public boolean isCaughtError() {
        return this.caughtError;
    }

    public void caughtError() {
        this.caughtError = true;
    }

    protected Direction transformFacingForRotation(Direction facing) {
        return facing;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerSpiritFurnace(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.evilcraft.spirit_furnace");
    }

    static {
        BOX_COOK_TICK_ACTIONS = new LinkedHashMap();
        BOX_COOK_TICK_ACTIONS.put(BlockBoxOfEternalClosure.class, new BoxCookTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 2;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }

    public static class Metadata
    extends BlockEntityWorking.Metadata {
        private Metadata() {
            super(SLOTS);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, Level world) {
            return !itemStack.isEmpty() && BlockEntitySpiritFurnace.getAllowedCookItem() == itemStack.getItem();
        }

        @Override
        protected Block getBlock() {
            return (Block)RegistryEntries.BLOCK_SPIRIT_FURNACE.get();
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityWorking.CapabilityRegistrar<BlockEntitySpiritFurnace, MutableDouble> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntitySpiritFurnace>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void registerTankInventoryCapabilitiesItem() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> {
                int[] nArray;
                SimpleInventory simpleInventory = blockEntity.getInventory();
                if (direction == Direction.UP || direction == Direction.DOWN) {
                    nArray = SLOTS_DROP;
                } else {
                    int[] nArray2 = new int[2];
                    nArray2[0] = 1;
                    nArray = nArray2;
                    nArray2[1] = 0;
                }
                return new ItemHandlerSlotMasked(this, (Container)simpleInventory, nArray, (BlockEntitySpiritFurnace)blockEntity){
                    final /* synthetic */ BlockEntitySpiritFurnace val$blockEntity;
                    {
                        this.val$blockEntity = blockEntitySpiritFurnace;
                        super(inventory, slots);
                    }

                    public ItemStack extractItem(int slot, int amount, boolean simulate) {
                        ItemStack extracted = super.extractItem(slot, amount, simulate);
                        if (slot > 1 && !extracted.isEmpty() && !simulate) {
                            this.val$blockEntity.resetWork(false);
                        }
                        return extracted;
                    }
                };
            });
        }
    }
}

