/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.block.BlockColossalBloodChest;
import org.cyclops.evilcraft.blockentity.BlockEntityColossalBloodChest;
import org.cyclops.evilcraft.core.algorithm.Wrapper;

public class BlockReinforcedUndeadPlank
extends Block
implements CubeDetector.IDetectionListener {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public BlockReinforcedUndeadPlank(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) != false ? RenderShape.ENTITYBLOCK_ANIMATED : super.getRenderShape(blockState);
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.captureBlockSnapshots) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, pos, true);
        }
    }

    public void onPlace(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.onPlace(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.getBlock() != blockStateOld.getBlock() && !((Boolean)blockStateNew.getValue((Property)ACTIVE)).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, blockPos, true);
        }
    }

    public void destroy(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        super.destroy(worldIn, pos, state);
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)worldIn, pos, false);
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockColossalBloodChest.triggerDetector((LevelReader)world, pos, false);
        }
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.wasExploded(world, pos, explosion);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.getBlockState(location).getBlock();
        if (block == this) {
            boolean change = (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)world.getBlockState(location), (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) == false;
            ((Level)world).setBlock(location, (BlockState)world.getBlockState(location).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            if (change) {
                BlockEntityColossalBloodChest.detectStructure((Level)world, location, size, valid, originCorner);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand pHand, BlockHitResult pHitResult) {
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            final Wrapper tileLocationWrapper = new Wrapper();
            BlockEntityColossalBloodChest.getCubeDetector().detect((LevelReader)world, blockPos, null, new CubeDetector.IValidationAction(){

                public Component onValidate(BlockPos location, BlockState blockState) {
                    if (blockState.getBlock() instanceof BlockColossalBloodChest) {
                        tileLocationWrapper.set(location);
                    }
                    return null;
                }
            }, false);
            BlockPos tileLocation = (BlockPos)tileLocationWrapper.get();
            if (tileLocation != null) {
                return world.getBlockState(tileLocation).useItemOn(pStack, world, player, pHand, pHitResult.withPosition(tileLocation));
            }
            return super.useItemOn(pStack, blockState, world, blockPos, player, pHand, pHitResult);
        }
        BlockColossalBloodChest.addPlayerChatError(world, blockPos, player, pHand);
        return ItemInteractionResult.FAIL;
    }
}

