/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import java.util.Random;
import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotFertilizer;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.workers.tools.ModuleFarmer;
import vswe.stevescarts.polylib.EntityData;

public class ModuleFertilizer
extends ModuleWorker
implements ISuppliesModule {
    private int tankPosX;
    private int tankPosY = 20;
    private int range = 1;
    private final int fertPerBonemeal = 4;
    private final int maxStacksOfBones = 1;
    private final Random random = new Random();
    private final EntityData<Integer> fertilizer = new EntityData(this.getCart(), new IntData(0));

    public ModuleFertilizer(EntityMinecartModular cart) {
        super(cart);
        this.tankPosX = this.guiWidth() - 21;
    }

    @Override
    public byte getWorkPriority() {
        return 127;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleFarmer)) continue;
            this.range = ((ModuleFarmer)module).getExternalRange();
            break;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/fertilize.png");
        this.drawImage(guiGraphics, gui, this.tankPosX, this.tankPosY, 0, 0, 18, 27);
        float percentage = (float)this.getFertAmount() / (float)this.getMaxFert();
        int size = (int)(percentage * 23.0f);
        this.drawImage(guiGraphics, gui, this.tankPosX + 2, this.tankPosY + 2 + (23 - size), 18, 23 - size, 14, size);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.FERTILIZERS.translate(new String[0]) + ": " + this.getFertAmount() + " / " + this.getMaxFert(), x, y, this.tankPosX, this.tankPosY, 18, 27);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return super.guiWidth() + 25;
    }

    @Override
    public int guiHeight() {
        return Math.max(super.guiHeight(), 50);
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotFertilizer(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public boolean work() {
        Level world = this.getCart().level();
        BlockPos next = this.getNextblock();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; !(j > this.range || this.random.nextInt(25) == 0 && this.fertilize(world, next.offset(i, 0, j))); ++j) {
            }
        }
        return false;
    }

    private boolean fertilize(Level world, BlockPos pos) {
        CropBlock growable;
        BlockState stateOfTopBlock = world.getBlockState(pos);
        Block blockTop = stateOfTopBlock.getBlock();
        if (this.getFertAmount() > 0 && blockTop instanceof CropBlock && (growable = (CropBlock)blockTop).isValidBonemealTarget((LevelReader)world, pos, stateOfTopBlock) && growable.isBonemealSuccess(world, this.getCart().random, pos, stateOfTopBlock)) {
            growable.performBonemeal((ServerLevel)world, this.getCart().random, pos, stateOfTopBlock);
            this.setFertAmount(this.getFertAmount() - 2);
            return true;
        }
        return false;
    }

    private void addFert(int amount) {
        int val = this.getFertAmount();
        this.setFertAmount(val += amount);
    }

    public int getFertAmount() {
        return this.fertilizer.get();
    }

    private void setFertAmount(int val) {
        if (!this.isPlaceholder()) {
            this.fertilizer.set(val);
        }
    }

    @Override
    public void update() {
        super.update();
        this.loadSupplies();
    }

    private void loadSupplies() {
        if (this.getCart().level().isClientSide) {
            return;
        }
        ItemStack stack = this.getStack(0);
        if (!stack.isEmpty()) {
            int amount = 0;
            if (stack.is(Items.BONE_MEAL)) {
                amount = 1;
            } else if (stack.is(Tags.Items.BONES)) {
                amount = 3;
            } else if (stack.is(Items.BONE_BLOCK)) {
                amount = 9;
            }
            if (amount == 0) {
                return;
            }
            if (this.getFertAmount() + (amount *= 4) <= 768) {
                stack.shrink(1);
                this.addFert(amount);
            }
        }
    }

    private int getMaxFert() {
        return 768;
    }

    @Override
    protected void save(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        tagCompound.putShort(this.generateNBTName("Fert", id), (short)this.getFertAmount());
    }

    @Override
    protected void load(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        this.setFertAmount(tagCompound.getShort(this.generateNBTName("Fert", id)));
    }

    @Override
    public boolean haveSupplies() {
        return this.getFertAmount() > 0;
    }
}

