/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.engines;

import net.creeperhost.polylib.helpers.FuelHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotFuel;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;

public abstract class ModuleCoalBase
extends ModuleEngine {
    private int fireCoolDown;
    private int fireIndex;

    public ModuleCoalBase(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    protected void loadFuel() {
        int consumption = this.getCart().getConsumption(true) * 2;
        if (this.getFuelLevel() <= consumption) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                this.setFuelLevel(this.getFuelLevel() + FuelHelper.getItemBurnTime((ItemStack)this.getStack(i)));
                if (this.getFuelLevel() <= consumption) continue;
                if (this.getStack(i).isEmpty()) break;
                if (this.getStack(i).hasCraftingRemainingItem()) {
                    this.setStack(i, this.getStack(i).getCraftingRemainingItem());
                } else {
                    ItemStack stack = this.getStack(i);
                    stack.shrink(1);
                }
                if (this.getStack(i).getCount() != 0) break;
                this.setStack(i, ItemStack.EMPTY);
                break;
            }
        }
    }

    @Override
    public int getTotalFuel() {
        int totalfuel = this.getFuelLevel();
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i).isEmpty()) continue;
            totalfuel += FuelHelper.getItemBurnTime((ItemStack)this.getStack(i)) * this.getStack(i).getCount();
        }
        return totalfuel;
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public void smoke() {
        Direction smokeSide = this.getCart().getMotionDirection().getOpposite();
        double oX = smokeSide.getStepX();
        double oZ = smokeSide.getStepZ();
        if (this.getCart().random.nextInt(2) == 0) {
            this.getCart().level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getCart().getX() + oX * 0.85, this.getCart().getY() + 0.12, this.getCart().getZ() + oZ * 0.85, 0.0, 0.0, 0.0);
        }
        if (this.getCart().random.nextInt(30) == 0) {
            this.getCart().level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getCart().getX() + oX * 0.75, this.getCart().getY() + 0.15, this.getCart().getZ() + oZ * 0.75, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotFuel(this.getCart(), slotId, 8 + x * 18, 23 + 18 * y);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ENGINES.COAL.translate(new String[0]), 8, 6, 0x404040);
        Object strfuel = Localization.MODULES.ENGINES.NO_FUEL.translate(new String[0]);
        if (this.getFuelLevel() > 0) {
            strfuel = "Fuel: " + this.getFuelLevel();
        }
        this.drawString(guiGraphics, gui, (String)strfuel, 8, 48, 0x404040);
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.getFuelLevel());
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.setFuelLevel(data);
            if (this.getFuelLevel() < 0) {
                this.setFuelLevel(this.getFuelLevel() + 65536);
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.fireCoolDown <= 0) {
            this.fireIndex = this.getCart().random.nextInt(4) + 1;
            this.fireCoolDown = 2;
        } else {
            --this.fireCoolDown;
        }
    }

    public int getFireIndex() {
        if (this.getCart().isEngineBurning()) {
            return this.fireIndex;
        }
        return 0;
    }

    @Override
    protected void save(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        super.save(tagCompound, id, provider);
        tagCompound.putShort(this.generateNBTName("Fuel", id), (short)this.getFuelLevel());
    }

    @Override
    protected void load(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        super.load(tagCompound, id, provider);
        this.setFuelLevel(tagCompound.getShort(this.generateNBTName("Fuel", id)));
        if (this.getFuelLevel() < 0) {
            this.setFuelLevel(this.getFuelLevel() + 65536);
        }
    }

    public abstract double getFuelMultiplier();
}

