/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons.plants;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vswe.stevescarts.api.farms.ICropModule;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleNetherwart
extends ModuleAddon
implements ICropModule {
    public ModuleNetherwart(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean isSeedValid(@Nonnull ItemStack seed) {
        return seed.getItem() == Items.NETHER_WART;
    }

    @Override
    public BlockState getCropFromSeed(@Nonnull ItemStack seed, Level world, BlockPos pos) {
        Block cropBlock = Block.byItem((Item)seed.getItem());
        BlockState state = cropBlock.defaultBlockState();
        if (state.is(Blocks.NETHER_WART)) {
            return state;
        }
        return null;
    }

    @Override
    public boolean isReadyToHarvest(Level world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.getBlock() == Blocks.NETHER_WART && (Integer)blockState.getValue((Property)NetherWartBlock.AGE) == 3;
    }
}

