/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotEnchantment;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.EnchantData;
import vswe.stevescarts.helpers.EnchantmentData;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ModularEnchantments;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleEnchants
extends ModuleAddon {
    private final ArrayList<ModularEnchantments.EnchantmentType> enabledTypes;
    private final EntityData<EnchantmentData> enchant0 = new EntityData<EnchantmentData>(this.getCart(), new EnchantData(new EnchantmentData(null)));
    private final EntityData<EnchantmentData> enchant1 = new EntityData<EnchantmentData>(this.getCart(), new EnchantData(new EnchantmentData(null)));
    private final EntityData<EnchantmentData> enchant2 = new EntityData<EnchantmentData>(this.getCart(), new EnchantData(new EnchantmentData(null)));

    public ModuleEnchants(EntityMinecartModular cart) {
        super(cart);
        this.enabledTypes = new ArrayList();
    }

    @NotNull
    public EnchantmentData getEnchant(int index) {
        return (index == 0 ? this.enchant0 : (index == 1 ? this.enchant1 : this.enchant2)).get();
    }

    public void setEnchant(int index, EnchantmentData data) {
        (index == 0 ? this.enchant0 : (index == 1 ? this.enchant1 : this.enchant2)).set(data, data.isDirty());
    }

    public int getFortuneLevel() {
        if (this.useSilkTouch()) {
            return 0;
        }
        return this.getEnchantLevel((ResourceKey<Enchantment>)Enchantments.FORTUNE);
    }

    public boolean useSilkTouch() {
        return false;
    }

    public int getUnbreakingLevel() {
        return this.getEnchantLevel((ResourceKey<Enchantment>)Enchantments.UNBREAKING);
    }

    public int getEfficiencyLevel() {
        return this.getEnchantLevel((ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
    }

    public int getPowerLevel() {
        return this.getEnchantLevel((ResourceKey<Enchantment>)Enchantments.POWER);
    }

    public int getPunchLevel() {
        return this.getEnchantLevel((ResourceKey<Enchantment>)Enchantments.PUNCH);
    }

    public boolean useFlame() {
        return this.getEnchantLevel((ResourceKey<Enchantment>)Enchantments.FLAME) > 0;
    }

    public boolean useInfinity() {
        return this.getEnchantLevel((ResourceKey<Enchantment>)Enchantments.INFINITY) > 0;
    }

    private int getEnchantLevel(ResourceKey<Enchantment> enchant) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData test = this.getEnchant(i);
            if (test.getEnchantHolder() == null || !test.getEnchantHolder().is(enchant)) continue;
            return test.getLevel();
        }
        return 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotEnchantment(this.getCart(), this.enabledTypes, slotId, 8, 14 + y * 20);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.getStack(i).isEmpty() || this.getStack(i).getCount() <= 0) continue;
            int count = this.getStack(i).getCount();
            EnchantmentData data = ModularEnchantments.addBook(this.enabledTypes, this.getEnchant(i), this.getStack(i));
            if (this.getStack(i).getCount() == count) continue;
            boolean valid = true;
            for (int j = 0; j < 3; ++j) {
                if (i == j) continue;
                EnchantmentData data2 = this.getEnchant(j);
                if (data.getEnchant() == null || data2.getEnchant() == null || data.getEnchant() != data2.getEnchant()) continue;
                data.setEnchantment(null);
                ItemStack stack = this.getStack(i);
                stack.grow(1);
                valid = false;
                break;
            }
            if (valid && this.getStack(i).getCount() <= 0) {
                this.setStack(i, ItemStack.EMPTY);
            }
            this.setEnchant(i, data);
        }
    }

    public void damageEnchant(ModularEnchantments.EnchantmentType type, int dmg) {
        for (int i = 0; i < 3; ++i) {
            Optional optkey;
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchantHolder() == null || !(optkey = data.getEnchantHolder().unwrapKey()).isPresent() || ModularEnchantments.getType((ResourceKey<Enchantment>)((ResourceKey)optkey.get())) != type) continue;
            data.damageEnchant(dmg);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/enchant.png");
        for (int i = 0; i < 3; ++i) {
            Optional optkey;
            int[] box = this.getBoxRect(i);
            if (this.inRect(x, y, box)) {
                this.drawImage(guiGraphics, gui, box, 65, 0);
            } else {
                this.drawImage(guiGraphics, gui, box, 0, 0);
            }
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchantHolder() == null || !(optkey = data.getEnchantHolder().unwrapKey()).isPresent()) continue;
            int maxlevel = data.getEnchant().getMaxLevel();
            int value = data.getValue();
            for (int j = 0; j < maxlevel; ++j) {
                int[] bar = this.getBarRect(i, j, maxlevel);
                if (j != maxlevel - 1) {
                    this.drawImage(guiGraphics, gui, bar[0] + bar[2], bar[1], 61 + j, 1, 1, bar[3]);
                }
                int levelmaxvalue = ModularEnchantments.getValue((ResourceKey<Enchantment>)((ResourceKey)optkey.get()), j + 1);
                if (value > 0) {
                    float mult = (float)value / (float)levelmaxvalue;
                    if (mult > 1.0f) {
                        mult = 1.0f;
                    }
                    bar[2] = (int)((float)bar[2] * mult);
                    this.drawImage(guiGraphics, gui, bar, 1, 13 + 11 * j);
                }
                value -= levelmaxvalue;
            }
        }
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.getEnchant(i);
            String str = data.getEnchant() != null ? data.getInfoText() : Localization.MODULES.ADDONS.ENCHANT_INSTRUCTION.translate(new String[0]);
            this.drawStringOnMouseOver(guiGraphics, gui, str, x, y, this.getBoxRect(i));
        }
    }

    private int[] getBoxRect(int id) {
        return new int[]{40, 17 + id * 20, 61, 12};
    }

    private int[] getBarRect(int id, int barid, int maxlevel) {
        int width = (59 - (maxlevel - 1)) / maxlevel;
        return new int[]{41 + (width + 1) * barid, 18 + id * 20, width, 10};
    }

    @Override
    public int numberOfGuiData() {
        return 9;
    }

    @Override
    protected void save(CompoundTag nbt, int id, @NotNull HolderLookup.Provider provider) {
        super.save(nbt, id, provider);
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchant() == null) continue;
            nbt.put(this.generateNBTName("enchant" + i, id), (Tag)data.save(provider));
        }
    }

    @Override
    protected void load(CompoundTag nbt, int id, @NotNull HolderLookup.Provider provider) {
        super.load(nbt, id, provider);
        for (int i = 0; i < 3; ++i) {
            if (!nbt.contains(this.generateNBTName("enchant" + i, id))) continue;
            EnchantmentData data = EnchantmentData.load(nbt.getCompound(this.generateNBTName("enchant" + i, id)), provider);
            this.setEnchant(i, data);
        }
    }

    @Override
    public int guiWidth() {
        return 110;
    }

    public void addType(ModularEnchantments.EnchantmentType type) {
        this.enabledTypes.add(type);
    }
}

