/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.datagen;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.polylib.helpers.RegistryNameHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.datagen.GeneratorLanguage;
import vswe.stevescarts.datagen.GeneratorRecipes;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModItems;

@EventBusSubscriber(modid="stevescarts", bus=EventBusSubscriber.Bus.MOD)
public class StevesCartsDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new GeneratorRecipes(generator.getPackOutput(), event.getLookupProvider()));
            generator.addProvider(true, (DataProvider)new GeneratorLoots(generator.getPackOutput(), event.getLookupProvider()));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new GeneratorBlockTags(generator.getPackOutput(), event.getLookupProvider(), generator, event.getExistingFileHelper()));
            generator.addProvider(true, (DataProvider)new GeneratorLanguage(generator));
            generator.addProvider(true, (DataProvider)new GeneratorItemModels(generator, event.getExistingFileHelper()));
        }
    }

    static class GeneratorLoots
    extends LootTableProvider {
        public GeneratorLoots(PackOutput output, CompletableFuture<HolderLookup.Provider> future) {
            super(output, Set.of(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.BLOCK)), future);
        }

        private static class Blocks
        extends BlockLootSubProvider {
            protected Blocks(HolderLookup.Provider provider) {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
            }

            protected void generate() {
                ModBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> this.dropSelf((Block)blockRegistryObject.get()));
            }

            @NotNull
            protected Iterable<Block> getKnownBlocks() {
                ArrayList list = new ArrayList();
                ModBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> list.add((Block)blockRegistryObject.get()));
                return ImmutableList.copyOf(list);
            }
        }
    }

    static class GeneratorBlockTags
    extends BlockTagsProvider {
        public GeneratorBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, DataGenerator generator, ExistingFileHelper helper) {
            super(output, lookupProvider, "stevescarts", helper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            ModBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)blockRegistryObject.get())));
            this.tag(BlockTags.RAILS).add((Object)((Block)ModBlocks.ADVANCED_DETECTOR.get())).add((Object)((Block)ModBlocks.JUNCTION.get()));
            this.tag(BlockTags.BEACON_BASE_BLOCKS).add((Object)((Block)ModBlocks.GALGADORIAN_METAL.get())).add((Object)((Block)ModBlocks.REINFORCED_METAL.get())).add((Object)((Block)ModBlocks.ENHANCED_GALGADORIAN_METAL.get()));
        }
    }

    static class GeneratorItemModels
    extends ItemModelProvider {
        public GeneratorItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator.getPackOutput(), "stevescarts", existingFileHelper);
        }

        protected void registerModels() {
            ModItems.MODULES.forEach((moduleData, itemSupplier) -> this.singleTexture(((ResourceLocation)RegistryNameHelper.getRegistryName((Item)((Item)itemSupplier.get())).get()).getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + moduleData.getRawName() + "_icon")));
            ModItems.COMPONENTS.forEach((moduleData, itemSupplier) -> this.singleTexture(((ResourceLocation)RegistryNameHelper.getRegistryName((Item)((Item)itemSupplier.get())).get()).getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + moduleData.getRawName() + "_icon")));
        }

        public void registerDefaultItemBlockModel(Block block) {
            String path = ((ResourceLocation)RegistryNameHelper.getRegistryName((Block)block).get()).getPath();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        @NotNull
        public String getName() {
            return "Item Models";
        }
    }

    static class GeneratorBlockStates
    extends BlockStateProvider {
        public GeneratorBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen.getPackOutput(), "stevescarts", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock((Block)ModBlocks.ENHANCED_GALGADORIAN_METAL.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/storage_enhanced_galgadorian")));
            this.simpleBlock((Block)ModBlocks.REINFORCED_METAL.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/storage_reinforced_metal")));
            this.simpleBlock((Block)ModBlocks.GALGADORIAN_METAL.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/storage_galgadorian")));
        }

        public void registerSidedBlock(Block block, String folder) {
            this.horizontalBlock(block, (ModelFile)this.models().orientableWithBottom(this.getResourceLocation(block).getPath(), this.modLoc("block/" + folder + "/side"), this.modLoc("block/" + folder + "/front"), this.modLoc("block/" + folder + "/bottom"), this.modLoc("block/" + folder + "/top")));
        }

        public ResourceLocation getResourceLocation(Block block) {
            return BuiltInRegistries.BLOCK.getKey((Object)block);
        }
    }
}

