/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.modules.realtimers.ModuleDynamite;

public class ModelDynamite
extends ModelCartbase {
    private ModelPart[] dynamites = new ModelPart[54];
    private float[] yPos = new float[54];
    private float sizemult;

    public ModelDynamite(ResourceLocation resource) {
        super(null, resource);
        this.buildModels();
    }

    public void buildModels() {
        this.createDynamite(0.0f, 0.0f, 0.0f, 0);
        this.createDynamite(-1.0f, 0.0f, 0.0f, 3);
        this.createDynamite(1.0f, 0.0f, 0.0f, 4);
        this.createDynamite(-2.0f, 0.0f, 0.0f, 18);
        this.createDynamite(2.0f, 0.0f, 0.0f, 19);
        this.createDynamite(-0.5f, 1.0f, 0.0f, 9);
        this.createDynamite(0.5f, 1.0f, 0.0f, 10);
        this.createDynamite(-1.5f, 1.0f, 0.0f, 24);
        this.createDynamite(1.5f, 1.0f, 0.0f, 25);
        this.createDynamite(0.0f, 2.0f, 0.0f, 15);
        this.createDynamite(-1.0f, 2.0f, 0.0f, 30);
        this.createDynamite(1.0f, 2.0f, 0.0f, 31);
        this.createDynamite(-3.0f, 0.0f, 0.0f, 36);
        this.createDynamite(3.0f, 0.0f, 0.0f, 37);
        this.createDynamite(-2.5f, 1.0f, 0.0f, 42);
        this.createDynamite(2.5f, 1.0f, 0.0f, 43);
        this.createDynamite(-2.0f, 2.0f, 0.0f, 48);
        this.createDynamite(2.0f, 2.0f, 0.0f, 49);
        this.createDynamite(0.0f, 0.0f, -1.0f, 1);
        this.createDynamite(-1.0f, 0.0f, -1.0f, 5);
        this.createDynamite(1.0f, 0.0f, -1.0f, 7);
        this.createDynamite(-2.0f, 0.0f, -1.0f, 20);
        this.createDynamite(2.0f, 0.0f, -1.0f, 22);
        this.createDynamite(-0.5f, 1.0f, -1.0f, 11);
        this.createDynamite(0.5f, 1.0f, -1.0f, 13);
        this.createDynamite(-1.5f, 1.0f, -1.0f, 26);
        this.createDynamite(1.5f, 1.0f, -1.0f, 28);
        this.createDynamite(0.0f, 2.0f, -1.0f, 16);
        this.createDynamite(-1.0f, 2.0f, -1.0f, 32);
        this.createDynamite(1.0f, 2.0f, -1.0f, 34);
        this.createDynamite(-3.0f, 0.0f, -1.0f, 38);
        this.createDynamite(3.0f, 0.0f, -1.0f, 40);
        this.createDynamite(-2.5f, 1.0f, -1.0f, 44);
        this.createDynamite(2.5f, 1.0f, -1.0f, 46);
        this.createDynamite(-2.0f, 2.0f, -1.0f, 50);
        this.createDynamite(2.0f, 2.0f, -1.0f, 52);
        this.createDynamite(0.0f, 0.0f, 1.0f, 2);
        this.createDynamite(-1.0f, 0.0f, 1.0f, 8);
        this.createDynamite(1.0f, 0.0f, 1.0f, 6);
        this.createDynamite(-2.0f, 0.0f, 1.0f, 21);
        this.createDynamite(2.0f, 0.0f, 1.0f, 23);
        this.createDynamite(-0.5f, 1.0f, 1.0f, 14);
        this.createDynamite(0.5f, 1.0f, 1.0f, 12);
        this.createDynamite(-1.5f, 1.0f, 1.0f, 29);
        this.createDynamite(1.5f, 1.0f, 1.0f, 27);
        this.createDynamite(0.0f, 2.0f, 1.0f, 17);
        this.createDynamite(-1.0f, 2.0f, 1.0f, 35);
        this.createDynamite(1.0f, 2.0f, 1.0f, 33);
        this.createDynamite(-3.0f, 0.0f, 1.0f, 41);
        this.createDynamite(3.0f, 0.0f, 1.0f, 39);
        this.createDynamite(-2.5f, 1.0f, 1.0f, 47);
        this.createDynamite(2.5f, 1.0f, 1.0f, 45);
        this.createDynamite(-2.0f, 2.0f, 1.0f, 53);
        this.createDynamite(2.0f, 2.0f, 1.0f, 51);
    }

    private void createDynamite(float x, float y, float z, int index) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition anchor = modelPartData.addOrReplaceChild("anchor_" + index, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition dynamite = anchor.addOrReplaceChild("dynamite_" + index, CubeListBuilder.create().addBox(-8.0f, -4.0f, -4.0f, 16.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)(x * 10.0f), (float)(y * -8.0f), (float)(z * 18.0f), (float)0.0f, (float)1.5707964f, (float)0.0f));
        this.dynamites[index] = dynamite.bake(64, 64);
        this.yPos[index] = y * -8.0f;
    }

    @Override
    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, int colour) {
        poseStack.pushPose();
        poseStack.scale(this.sizemult * 0.25f, this.sizemult * 0.25f, this.sizemult * 0.25f);
        for (ModelPart dynamite : this.dynamites) {
            if (!dynamite.visible) continue;
            dynamite.render(poseStack, vertexConsumers, light, OverlayTexture.pack((int)OverlayTexture.u((float)((this.sizemult - 1.0f) * 2.0f)), (int)10), colour);
        }
        poseStack.popPose();
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        if (module == null) {
            this.sizemult = 1.5f;
            for (ModelPart dynamite : this.dynamites) {
                dynamite.visible = true;
            }
        } else {
            float fusemult = (float)Math.abs(Math.sin((double)((float)((ModuleDynamite)module).getFuse() / (float)((ModuleDynamite)module).getFuseLength()) * Math.PI * 6.0));
            this.sizemult = fusemult * 0.5f + 1.0f;
            float size = ((ModuleDynamite)module).explosionSize();
            float max = 44.0f;
            float perModel = max / (float)this.dynamites.length;
            for (int j = 0; j < this.dynamites.length; ++j) {
                this.dynamites[j].visible = !((float)j * perModel >= size);
                this.dynamites[j].y = this.yPos[j] + -24.0f / this.sizemult;
            }
        }
    }
}

