/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.containers.ContainerLiquid;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.init.ModBlocks;

public class GuiLiquid
extends AbstractContainerScreen<ContainerLiquid> {
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/liquidmanager.png");
    private static ResourceLocation textureExtra = ResourceHelper.getResource("/gui/liquidmanagerExtra.png");
    private final ContainerLiquid containerLiquid;

    public GuiLiquid(ContainerLiquid containerLiquid, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerLiquid, playerInventory, iTextComponent);
        this.containerLiquid = containerLiquid;
        this.imageWidth = 230;
        this.imageHeight = 222;
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_230450_2_, int mouseX, int mouseY) {
        int j;
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.getLiquid().getTanks() != null) {
            for (int i = 0; i < 4; ++i) {
                int[] coords = this.getTankCoords(i);
                this.getLiquid().getTanks()[i].drawFluid(guiGraphics, this, this.getGuiLeft() + coords[0], this.getGuiTop() + coords[1]);
            }
        }
        boolean version = this.containerLiquid.getLayoutType() != 0;
        for (j = 0; j < 2; ++j) {
        }
        for (j = 0; j < 4; ++j) {
            int[] coords2 = this.getTankCoords(j);
            int n = j % 2;
        }
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        for (int i = 0; i < 4; ++i) {
            this.drawArrow(guiGraphics, i, left, top);
            int color = this.containerLiquid.getColor()[i] - 1;
            if (color == 4) continue;
            this.drawColors(guiGraphics, i, color, left, top);
        }
        ItemRenderer renderitem = Minecraft.getInstance().getItemRenderer();
        int[] coords = this.getMiddleCoords();
        guiGraphics.renderItem(new ItemStack((ItemLike)this.getBlock(), 1), left + coords[0], top + coords[1]);
        for (int j2 = 0; j2 < 4; ++j2) {
            this.drawItems(j2, renderitem, left, top);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int p_230451_2_, int p_230451_3_) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_230430_4_) {
        int i;
        this.renderBackground(guiGraphics, mouseX, mouseY, p_230430_4_);
        super.render(guiGraphics, mouseX, mouseY, p_230430_4_);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int[] coords = this.getMiddleCoords();
        guiGraphics.drawString(Minecraft.getInstance().font, this.getManagerName(), this.leftPos + coords[0] - 34, this.topPos + 4, 0xFFFFFF);
        guiGraphics.drawString(Minecraft.getInstance().font, Localization.GUI.MANAGER.TITLE.translate(new String[0]), this.leftPos + coords[0] + coords[2], this.topPos + 4, 0xFFFFFF);
        for (i = 0; i < 4; ++i) {
            coords = this.getTextCoords(i);
            String str = this.getMaxSizeText(i);
            guiGraphics.drawString(Minecraft.getInstance().font, str, this.leftPos + coords[0], this.topPos + coords[1], 0xFFFFFF);
        }
        for (i = 0; i < 4; ++i) {
            try {
                this.drawExtraOverlay(guiGraphics, i, mouseX, mouseY);
                this.drawMouseOver(guiGraphics, Localization.GUI.MANAGER.CHANGE_TRANSFER_DIRECTION.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + (this.containerLiquid.toCart()[i] ? Localization.GUI.MANAGER.DIRECTION_TO_CART.translate(new String[0]) : Localization.GUI.MANAGER.DIRECTION_FROM_CART.translate(new String[0])), mouseX, mouseY, this.getArrowCoords(i));
                this.drawMouseOver(guiGraphics, Localization.GUI.MANAGER.CHANGE_TURN_BACK_SETTING.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + (this.containerLiquid.getColor()[i] == 5 ? Localization.GUI.MANAGER.TURN_BACK_NOT_SELECTED.translate(new String[0]) : (this.containerLiquid.doReturn()[this.containerLiquid.getColor()[i] - 1] ? Localization.GUI.MANAGER.TURN_BACK_DO.translate(new String[0]) : Localization.GUI.MANAGER.TURN_BACK_DO_NOT.translate(new String[0]))), mouseX, mouseY, this.getReturnCoords(i));
                this.drawMouseOver(guiGraphics, Localization.GUI.MANAGER.CHANGE_TRANSFER_SIZE.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + this.getMaxSizeOverlay(i), mouseX, mouseY, this.getTextCoords(i));
                this.drawMouseOver(guiGraphics, Localization.GUI.MANAGER.CHANGE_SIDE.translate(new String[0]) + " " + Localization.GUI.MANAGER.CURRENT_SIDE.translate(new String[0]) + ": " + (new String[]{Localization.GUI.MANAGER.SIDE_RED.translate(new String[0]), Localization.GUI.MANAGER.SIDE_BLUE.translate(new String[0]), Localization.GUI.MANAGER.SIDE_YELLOW.translate(new String[0]), Localization.GUI.MANAGER.SIDE_GREEN.translate(new String[0]), Localization.GUI.MANAGER.SIDE_DISABLED.translate(new String[0])})[this.containerLiquid.getColor()[i] - 1], mouseX, mouseY, this.getColorpickerCoords(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.drawMouseOver(guiGraphics, this.getLayoutString() + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + this.getLayoutOption(this.containerLiquid.getLayoutType()), mouseX, mouseY, this.getMiddleCoords());
    }

    public void drawMouseOver(GuiGraphics guiGraphics, String str, int x, int y, int[] rect) {
        if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), rect)) {
            List toolTip = Arrays.stream(str.split("\n")).map(Component::literal).collect(Collectors.toList());
            guiGraphics.renderTooltip(Minecraft.getInstance().font, toolTip, Optional.empty(), x, y);
        }
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    protected int[] getMiddleCoords() {
        return new int[]{this.getCenterTargetX() + 45, 61, 20, 20};
    }

    protected String getManagerName() {
        return Localization.GUI.LIQUID.TITLE.translate(new String[0]);
    }

    protected int[] getTextCoords(int id) {
        int[] coords = this.getBoxCoords(id);
        int xCoord = coords[0];
        int yCoord = coords[1];
        yCoord = id >= 2 ? (yCoord -= 12) : (yCoord += 20);
        return new int[]{xCoord, yCoord, 20, 10};
    }

    protected int[] getBoxCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 4 + x * 82;
        int yCoord = 17 + y * 88;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerLiquid.getLayoutType(), x, y), 20, 20};
    }

    protected int[] getColorpickerCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 3 + x * 92;
        int yCoord = 49 + y * 32;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerLiquid.getLayoutType(), x, y), 8, 8};
    }

    protected int[] getReturnCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 14 + x * 70;
        int yCoord = 49 + y * 32;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerLiquid.getLayoutType(), x, y), 8, 8};
    }

    private void drawArrow(GuiGraphics guiGraphics, int id, int left, int top) {
        int sourceX = this.getArrowSourceX();
        int sourceY = 28;
        sourceY += 56 * id;
        if (!this.containerLiquid.toCart()[id]) {
            sourceX += 28;
        }
        int targetX = this.getArrowCoords(id)[0];
        int targetY = this.getArrowCoords(id)[1];
        int sizeX = 28;
        int sizeY = 28;
        guiGraphics.blit(textureExtra, left + targetX, top + targetY, sourceX, sourceY, sizeX, sizeY);
        if (id == this.getLiquid().getLastSetting() && this.containerLiquid.getColor()[id] != 5) {
            sourceY -= 28;
            int scaledProgress = this.getLiquid().moveProgressScaled(42);
            int offsetX = 0;
            int offsetY = 0;
            if (this.containerLiquid.toCart()[id]) {
                sizeX = 14;
                if (id % 2 == 0) {
                    offsetX = 14;
                }
                if ((sizeY = scaledProgress) > 19) {
                    sizeY = 19;
                }
                if (id < 2) {
                    offsetY = 28 - sizeY;
                }
            } else {
                sizeY = 14;
                if (id >= 2) {
                    offsetY = 14;
                }
                if ((sizeX = scaledProgress) > 19) {
                    sizeX = 19;
                }
                if (id % 2 == 1) {
                    offsetX = 28 - sizeX;
                }
            }
            guiGraphics.blit(textureExtra, left + targetX + offsetX, top + targetY + offsetY, sourceX + offsetX, sourceY + offsetY, sizeX, sizeY);
            offsetX = 0;
            offsetY = 0;
            sizeX = 28;
            sizeY = 28;
            if (scaledProgress > 19) {
                scaledProgress -= 19;
                if (this.containerLiquid.toCart()[id]) {
                    sizeX = scaledProgress;
                    if (sizeX > 23) {
                        sizeX = 23;
                    }
                    offsetX = id % 2 == 0 ? 22 - sizeX : 6;
                } else {
                    sizeY = scaledProgress;
                    if (sizeY > 23) {
                        sizeY = 23;
                    }
                    offsetY = id >= 2 ? 22 - sizeY : 6;
                }
                guiGraphics.blit(textureExtra, left + targetX + offsetX, top + targetY + offsetY, sourceX + offsetX, sourceY + offsetY, sizeX, sizeY);
            }
        }
    }

    protected void drawItems(int id, ItemRenderer renderitem, int left, int top) {
    }

    protected String getMaxSizeOverlay(int id) {
        float buckets = this.containerLiquid.getMaxAmountBuckets(id);
        if (this.containerLiquid.getMaxAmount(id) == 0) {
            return Localization.GUI.LIQUID.TRANSFER_ALL.translate(new String[0]);
        }
        return Localization.GUI.LIQUID.TRANSFER_BUCKETS.translate(String.valueOf(buckets)) + Localization.GUI.LIQUID.TRANSFER_BUCKET_SHORT.translate(new String[0]);
    }

    protected String getMaxSizeText(int id) {
        float buckets = this.containerLiquid.getMaxAmountBuckets(id);
        if (this.containerLiquid.getMaxAmount(id) == 0) {
            return Localization.GUI.LIQUID.TRANSFER_ALL_SHORT.translate(new String[0]);
        }
        return buckets + Localization.GUI.LIQUID.TRANSFER_BUCKET_SHORT.translate(new String[0]);
    }

    protected int getArrowSourceX() {
        return 72;
    }

    protected int getColorSourceX() {
        return 128;
    }

    protected int getCenterTargetX() {
        return 62;
    }

    protected int[] getArrowCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 25 + x * 28;
        int yCoord = 17 + y * 76;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerLiquid.getLayoutType(), x, y), 28, 28};
    }

    protected void drawColors(GuiGraphics guiGraphics, int id, int color, int left, int top) {
        try {
            int[] coords = this.getReturnCoords(id);
            guiGraphics.blit(textureExtra, left + coords[0], top + coords[1], this.getColorSourceX() + (this.containerLiquid.doReturn()[this.containerLiquid.getColor()[id] - 1] ? 8 : 0), 80 + 8 * color, 8, 8);
            coords = this.getBoxCoords(id);
            guiGraphics.blit(textureExtra, left + coords[0] - 2, top + coords[1] - 2, this.getColorSourceX(), 20 * color, 20, 20);
            if (this.containerLiquid.getLayoutType() == 2) {
                int[] coords2 = this.getTankCoords(id);
                guiGraphics.blit(textureExtra, left + coords2[0], top + coords2[1], 36, 51 * color, 36, 51);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int offsetObjectY(int layout, int x, int y) {
        return -5 + y * 10;
    }

    protected void drawExtraOverlay(GuiGraphics guiGraphics, int id, int x, int y) {
        this.drawMouseOver(guiGraphics, this.getLiquid().getTanks()[id].getMouseOver(), x, y, this.getTankCoords(id));
    }

    protected Block getBlock() {
        return (Block)ModBlocks.LIQUID_MANAGER.get();
    }

    private int[] getTankCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = 25 + x * 144;
        int yCoord = 12 + y * 63;
        return new int[]{xCoord, yCoord, 36, 51};
    }

    private TileEntityLiquid getLiquid() {
        return this.containerLiquid.getTileEntityLiquid();
    }

    protected String getLayoutString() {
        return Localization.GUI.LIQUID.CHANGE_LAYOUT.translate(new String[0]);
    }

    protected String getLayoutOption(int id) {
        switch (id) {
            default: {
                return Localization.GUI.LIQUID.LAYOUT_ALL.translate(new String[0]);
            }
            case 1: {
                return Localization.GUI.LIQUID.LAYOUT_SIDE.translate(new String[0]);
            }
            case 2: 
        }
        return Localization.GUI.LIQUID.LAYOUT_COLOR.translate(new String[0]);
    }

    protected boolean sendOnClick(int id, int x, int y, byte data) {
        if (this.inRect(x, y, this.getBoxCoords(id))) {
            this.getLiquid().sendPacket(1, data);
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        int x = (int)mouseX;
        int y = (int)mouseY;
        if (this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.getMiddleCoords())) {
            this.getLiquid().sendPacket(5, (byte)(button == 0 ? 1 : -1));
        } else {
            for (int i = 0; i < 4; ++i) {
                byte data = (byte)i;
                data = (byte)(data | (byte)(button << 2));
                if (this.inRect(x, y, this.getArrowCoords(i))) {
                    this.getLiquid().sendPacket(0, (byte)i);
                    break;
                }
                if (this.inRect(x, y, this.getTextCoords(i))) {
                    this.getLiquid().sendPacket(2, data);
                    break;
                }
                if (this.inRect(x, y, this.getColorpickerCoords(i))) {
                    this.getLiquid().sendPacket(3, data);
                    break;
                }
                if (this.inRect(x, y, this.getReturnCoords(i))) {
                    this.getLiquid().sendPacket(4, (byte)i);
                    break;
                }
                if (this.sendOnClick(i, x, y, data)) break;
            }
        }
        return true;
    }
}

