/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.realtimers.ModuleArcade;

public abstract class ArcadeGame {
    private ModuleArcade module;
    private Localization.ARCADE name;

    public ArcadeGame(ModuleArcade module, Localization.ARCADE name) {
        this.name = name;
        this.module = module;
    }

    public String getName() {
        return this.name.translate(new String[0]);
    }

    public ModuleArcade getModule() {
        return this.module;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void update() {
        if (((Boolean)SCConfig.CLIENT.useArcadeSounds.get()).booleanValue()) {
            this.getModule().getCart().silent();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void keyPress(GuiMinecart gui, int id, int extraInformation) {
    }

    public void Save(CompoundTag tagCompound, int id) {
    }

    public void Load(CompoundTag tagCompound, int id) {
    }

    public void receivePacket(int id, byte[] data, Player player) {
    }

    public void checkGuiData(Object[] info) {
    }

    public void receiveGuiData(int id, short data) {
    }

    public boolean disableStandardKeyFunctionality() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundEvent sound, float volume, float pitch) {
        if (!((Boolean)SCConfig.CLIENT.useArcadeSounds.get()).booleanValue() || sound != null) {
            // empty if block
        }
    }

    public boolean allowKeyRepeat() {
        return false;
    }

    public void load(GuiMinecart gui) {
    }

    public void unload(GuiMinecart gui) {
        if (this.allowKeyRepeat()) {
            // empty if block
        }
    }

    public void drawImageInArea(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y, int u, int v, int w, int h) {
        this.drawImageInArea(guiGraphics, gui, x, y, u, v, w, h, 5, 4, 443, 168);
    }

    public void drawImageInArea(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y, int u, int v, int w, int h, int x1, int y1, int x2, int y2) {
        if (x < x1) {
            w -= x1 - x;
            u += x1 - x;
            x = x1;
        } else if (x + w > x2) {
            w = x2 - x;
        }
        if (y < y1) {
            h -= y1 - y;
            v += y1 - y;
            y = y1;
        } else if (y + h > y2) {
            h = y2 - y;
        }
        if (w > 0 && h > 0) {
            this.getModule().drawImage(guiGraphics, gui, x, y, u, v, w, h);
        }
    }
}

