/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.network.packets;

import it.hurts.octostudios.rarcompat.items.UmbrellaItem;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RepulsionUmbrellaPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<RepulsionUmbrellaPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rarcompat", (String)"repulsion"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RepulsionUmbrellaPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, RepulsionUmbrellaPacket>(){

        public void encode(RegistryFriendlyByteBuf buf, RepulsionUmbrellaPacket packet) {
        }

        @Nonnull
        public RepulsionUmbrellaPacket decode(@Nonnull RegistryFriendlyByteBuf buf) {
            return new RepulsionUmbrellaPacket();
        }
    };

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack stack = player.getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof UmbrellaItem)) {
                return;
            }
            UmbrellaItem relic = (UmbrellaItem)patt0$temp;
            Level level = player.getCommandSenderWorld();
            level.playSound(null, player.blockPosition(), SoundEvents.PHANTOM_FLAP, SoundSource.MASTER, 1.0f, 1.0f + player.getRandom().nextFloat() * 0.25f);
            player.getCooldowns().addCooldown((Item)relic, (int)(relic.getStatValue(stack, "glider", "cooldown") * 20.0));
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            relic.addCharges(stack, -1);
            Vec3 pos = player.position().add(player.getLookAngle());
            if (!level.isClientSide()) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, pos.x, pos.y, pos.z, 40, 0.5, 0.5, 0.5, (double)0.05f);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepulsionUmbrellaPacket)) {
            return false;
        }
        RepulsionUmbrellaPacket other = (RepulsionUmbrellaPacket)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepulsionUmbrellaPacket;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "RepulsionUmbrellaPacket()";
    }
}

