/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

public class PowerGloveItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"power").stat(StatData.builder((String)"amount").initialValue(0.8, 1.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.4).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).research(ResearchData.builder().star(0, 2, 24).star(1, 8, 23).star(2, 5, 18).star(3, 5, 11).star(4, 8, 7).star(5, 14, 7).star(6, 20, 13).star(7, 20, 20).star(8, 15, 23).star(9, 20, 24).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(5, 6).link(6, 7).link(7, 8).link(8, 9).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-2575872).borderBottom(-4882944).build()).beams(BeamsData.builder().startColor(-1322137).endColor(0x3D444D).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"power").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.VILLAGE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                Player player = (Player)livingEntity;
                if (player.tickCount % 20 == 0 && this.getTime(stack) <= 5 && this.canPlayerUseAbility(player, stack, "power")) break block3;
            }
            return;
        }
        this.addTime(stack, 1);
    }

    public void addTime(ItemStack stack, int val) {
        this.setTime(stack, this.getTime(stack) + val);
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setTime(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(val, 0));
    }

    @EventBusSubscriber
    public static class PowerGloveEvent {
        @SubscribeEvent
        public static void onPlayerAttack(LivingIncomingDamageEvent event) {
            PowerGloveItem relic;
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.POWER_GLOVE.value()));
            Item item = stack.getItem();
            if (!(item instanceof PowerGloveItem) || (relic = (PowerGloveItem)item).getTime(stack) < 5 || !relic.canPlayerUseAbility(player, stack, "power")) {
                return;
            }
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            relic.setTime(stack, 0);
            event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * relic.getStatValue(stack, "power", "amount")));
            RandomSource random = player.getRandom();
            for (int i = 0; i < 20; ++i) {
                ((ServerLevel)player.getCommandSenderWorld()).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(200 + random.nextInt(55), 100 + random.nextInt(100), random.nextInt(50)), (float)0.7f, (int)60, (float)0.9f), player.getX(), player.getY() + 1.0, player.getZ(), 1, 0.0, 0.5, 0.0, 0.05);
            }
        }
    }
}

