/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import top.theillusivec4.curios.api.SlotContext;

public class PocketPistonItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"discarding").stat(StatData.builder((String)"interaction").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 11, 27).star(1, 11, 23).star(2, 4, 19).star(3, 4, 23).star(4, 18, 19).star(5, 18, 23).star(6, 11, 15).star(7, 11, 6).star(8, 4, 10).star(9, 18, 10).link(0, 1).link(1, 2).link(1, 4).link(3, 0).link(0, 5).link(5, 4).link(2, 3).link(1, 6).link(2, 6).link(4, 6).link(3, 0).link(0, 5).link(5, 4).link(2, 3).link(6, 8).link(6, 9).link(7, 8).link(7, 9).build()).build()).ability(AbilityData.builder((String)"interaction").requiredLevel(5).stat(StatData.builder((String)"range").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 11, 27).star(1, 11, 23).star(2, 4, 19).star(3, 4, 23).star(4, 18, 19).star(5, 18, 23).star(6, 11, 15).star(7, 11, 6).star(8, 4, 10).star(9, 18, 10).link(0, 1).link(1, 2).link(1, 4).link(3, 0).link(0, 5).link(5, 4).link(2, 3).link(1, 6).link(2, 6).link(4, 6).link(3, 0).link(0, 5).link(5, 4).link(2, 3).link(6, 8).link(6, 9).link(7, 8).link(7, 9).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-3434424).borderBottom(-9803158).build()).beams(BeamsData.builder().startColor(-2248856).endColor(0x6A6A6A).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"discarding").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).source(LevelingSourceData.abilityBuilder((String)"interaction").initialValue(1).gem(GemShape.SQUARE, GemColor.RED).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.VILLAGE}).build()).build();
    }

    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        float modifier = (float)this.getStatValue(stack, "interaction", "range");
        if (!this.isAbilityUnlocked(stack, "interaction")) {
            return super.getRelicAttributeModifiers(stack);
        }
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.ENTITY_INTERACTION_RANGE, modifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).attribute(new RelicAttributeModifier.Modifier(Attributes.BLOCK_INTERACTION_RANGE, modifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).build();
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (newStack.getItem() != stack.getItem()) break block3;
            }
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.ENTITY_INTERACTION_RANGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.BLOCK_INTERACTION_RANGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @EventBusSubscriber
    public static class PocketPistonEvent {
        @SubscribeEvent
        public static void onContacted(BlockEvent.EntityPlaceEvent event) {
            PocketPistonItem relic;
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.POCKET_PISTON.value()));
            Item item = stack.getItem();
            if (!(item instanceof PocketPistonItem) || !(relic = (PocketPistonItem)item).canPlayerUseAbility(player, stack, "discarding")) {
                return;
            }
            int distance = (int)Math.sqrt(event.getPos().distToCenterSqr(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ()));
            if (distance >= 5) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }

        @SubscribeEvent
        public static void onContacted(LivingDestroyBlockEvent event) {
            PocketPistonItem relic;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.POCKET_PISTON.value()));
            Item item = stack.getItem();
            if (!(item instanceof PocketPistonItem) || !(relic = (PocketPistonItem)item).canPlayerUseAbility(player, stack, "discarding")) {
                return;
            }
            int distance = (int)Math.sqrt(event.getPos().distToCenterSqr(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ()));
            if (distance >= 5) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }

        @SubscribeEvent
        public static void onAttacking(AttackEntityEvent event) {
            PocketPistonItem relic;
            LivingEntity target;
            ItemStack stack;
            Player player;
            block5: {
                block4: {
                    player = event.getEntity();
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.POCKET_PISTON.value()));
                    Entity entity = event.getTarget();
                    if (!(entity instanceof LivingEntity)) break block4;
                    target = (LivingEntity)entity;
                    entity = stack.getItem();
                    if (entity instanceof PocketPistonItem && (relic = (PocketPistonItem)entity).canPlayerUseAbility(player, stack, "discarding")) break block5;
                }
                return;
            }
            float modifier = (float)relic.getStatValue(stack, "discarding", "interaction");
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            if (player.distanceTo((Entity)target) > 3.0f) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            Vec3 toEntity = target.position().subtract(player.position()).normalize().scale((double)modifier);
            target.setDeltaMovement(toEntity.x, toEntity.y / 2.0, toEntity.z);
        }
    }
}

