/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.quartzarsenal.neoforge;

import com.refinedmods.refinedstorage.quartzarsenal.common.Config;
import com.refinedmods.refinedstorage.quartzarsenal.common.QuartzArsenalIdentifierUtil;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigImpl
implements Config {
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec spec;
    private final Config.WirelessCraftingGridEntry wirelessCraftingGrid = new WirelessCraftingGridEntryImpl(this);

    public ConfigImpl() {
        this.spec = this.builder.build();
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public Config.WirelessCraftingGridEntry getWirelessCraftingGrid() {
        return this.wirelessCraftingGrid;
    }

    private static String translationKey(String value) {
        return QuartzArsenalIdentifierUtil.createQuartzArsenalTranslationKey("text.autoconfig", "option." + value);
    }

    private class WirelessCraftingGridEntryImpl
    implements Config.WirelessCraftingGridEntry {
        private final ModConfigSpec.LongValue energyCapacity;
        private final ModConfigSpec.LongValue openEnergyUsage;
        private final ModConfigSpec.LongValue craftingEnergyUsage;
        private final ModConfigSpec.LongValue autocraftingEnergyUsage;
        private final ModConfigSpec.LongValue clearMatrixEnergyUsage;
        private final ModConfigSpec.LongValue recipeTransferEnergyUsage;

        WirelessCraftingGridEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("wirelessCraftingGrid")).push("wirelessCraftingGrid");
            this.energyCapacity = configImpl.builder.translation(ConfigImpl.translationKey("wirelessCraftingGrid.energyCapacity")).defineInRange("energyCapacity", 1000L, 0L, Long.MAX_VALUE);
            this.openEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessCraftingGrid.openEnergyUsage")).defineInRange("openEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            this.craftingEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessCraftingGrid.craftingEnergyUsage")).defineInRange("craftingEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            this.autocraftingEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessCraftingGrid.autocraftingEnergyUsage")).defineInRange("autocraftingEnergyUsage", 10L, 0L, Long.MAX_VALUE);
            this.clearMatrixEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessCraftingGrid.clearMatrixEnergyUsage")).defineInRange("clearMatrixEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            this.recipeTransferEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessCraftingGrid.recipeTransferEnergyUsage")).defineInRange("recipeTransferEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyCapacity() {
            return (Long)this.energyCapacity.get();
        }

        @Override
        public long getOpenEnergyUsage() {
            return (Long)this.openEnergyUsage.get();
        }

        @Override
        public long getCraftingEnergyUsage() {
            return (Long)this.craftingEnergyUsage.get();
        }

        @Override
        public long getAutocraftingEnergyUsage() {
            return (Long)this.autocraftingEnergyUsage.get();
        }

        @Override
        public long getClearMatrixEnergyUsage() {
            return (Long)this.clearMatrixEnergyUsage.get();
        }

        @Override
        public long getRecipeTransferEnergyUsage() {
            return (Long)this.recipeTransferEnergyUsage.get();
        }
    }
}

