/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.crops;

import dev.ftb.mods.ftbultimine.api.crop.CropLikeHandler;
import dev.ftb.mods.ftbultimine.api.util.ItemCollector;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public enum VanillaCropLikeHandler implements CropLikeHandler
{
    INSTANCE;


    public static boolean looksLikeACrop(BlockState state) {
        return state.getBlock() instanceof BushBlock || state.getBlock() instanceof CocoaBlock;
    }

    public static boolean equivalentForSelection(BlockState orig, BlockState other) {
        return VanillaCropLikeHandler.looksLikeACrop(orig) && VanillaCropLikeHandler.looksLikeACrop(other) && VanillaCropLikeHandler.getBushType(orig.getBlock()) == VanillaCropLikeHandler.getBushType(other.getBlock());
    }

    @Override
    public boolean isApplicable(Level level, BlockPos pos, BlockState state) {
        CropBlock cropBlock;
        Block block = state.getBlock();
        return block instanceof CropBlock && (cropBlock = (CropBlock)block).isMaxAge(state) || state.getBlock() instanceof SweetBerryBushBlock && (Integer)state.getValue((Property)SweetBerryBushBlock.AGE) >= 3 || state.getBlock() instanceof CocoaBlock && (Integer)state.getValue((Property)CocoaBlock.AGE) >= 2;
    }

    @Override
    public boolean doHarvesting(Player player, BlockPos pos, BlockState state, ItemCollector itemCollector) {
        BlockEntity blockEntity = state.hasBlockEntity() ? player.level().getBlockEntity(pos) : null;
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)player.level()), (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)ItemStack.EMPTY);
        for (ItemStack stack : drops) {
            if (Block.byItem((Item)stack.getItem()) == state.getBlock() && this.consumesItemToReplant(state)) {
                stack.shrink(1);
            }
            itemCollector.add(stack);
        }
        this.resetAge(player.level(), pos, state);
        return true;
    }

    @Override
    public boolean isEquivalent(BlockState original, BlockState state) {
        return VanillaCropLikeHandler.equivalentForSelection(original, state);
    }

    private static int getBushType(Block block) {
        if (block instanceof CropBlock) {
            return 1;
        }
        if (block instanceof SaplingBlock) {
            return 2;
        }
        if (block instanceof CocoaBlock) {
            return 3;
        }
        if (block instanceof SweetBerryBushBlock) {
            return 4;
        }
        return 0;
    }

    private boolean consumesItemToReplant(BlockState state) {
        return state.getBlock() != Blocks.SWEET_BERRY_BUSH;
    }

    private void resetAge(Level level, BlockPos pos, BlockState currentState) {
        Block block = currentState.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            BlockState newState = (BlockState)currentState.setValue((Property)cropBlock.getAgeProperty(), (Comparable)Integer.valueOf(0));
            level.setBlock(pos, newState, 3);
        } else if (currentState.getBlock() instanceof SweetBerryBushBlock) {
            int currentAge = (Integer)currentState.getValue((Property)SweetBerryBushBlock.AGE);
            level.setBlock(pos, (BlockState)currentState.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(Math.min(currentAge, 1))), 3);
        } else if (currentState.getBlock() instanceof CocoaBlock) {
            level.setBlock(pos, (BlockState)currentState.setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(0)), 3);
        }
    }
}

