/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import tamaized.ae2jeiintegration.integration.modules.jei.GenericEntryStackHelper;

class GhostIngredientHandler
implements IGhostIngredientHandler<AEBaseScreen<?>> {
    GhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AEBaseScreen<?> gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ItemStack wrapped = GhostIngredientHandler.wrapDraggedItem(ingredient.getType(), ingredient.getIngredient());
        if (wrapped == null) {
            return Collections.emptyList();
        }
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        GhostIngredientHandler.addItemStackTargets(gui, targets, wrapped, ingredient.getType());
        return targets;
    }

    @Nullable
    private static <T> ItemStack wrapDraggedItem(IIngredientType<T> type, T ingredient) {
        return VanillaTypes.ITEM_STACK.castIngredient(ingredient).or(() -> {
            GenericStack genericStack = GenericEntryStackHelper.ingredientToStack(type, ingredient);
            if (genericStack != null) {
                return Optional.of(GenericStack.wrapInItemStack((GenericStack)genericStack));
            }
            return Optional.empty();
        }).orElse(null);
    }

    private static <I> void addItemStackTargets(AEBaseScreen<?> gui, List<IGhostIngredientHandler.Target<I>> targets, ItemStack draggedStack, IIngredientType<I> type) {
        for (Slot slot : ((AEBaseMenu)gui.getMenu()).slots) {
            FakeSlot fakeSlot;
            if (!slot.isActive() || !(slot instanceof FakeSlot) || !(fakeSlot = (FakeSlot)slot).canSetFilterTo(draggedStack)) continue;
            targets.add(new ItemSlotTarget<I>(type, gui, (AppEngSlot)fakeSlot));
        }
    }

    public void onComplete() {
    }

    private static class ItemSlotTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final IIngredientType<I> type;
        private final AppEngSlot slot;
        private final Rect2i area;

        public ItemSlotTarget(IIngredientType<I> type, AEBaseScreen<?> screen, AppEngSlot slot) {
            this.type = type;
            this.slot = slot;
            this.area = new Rect2i(screen.getGuiLeft() + slot.x, screen.getGuiTop() + slot.y, 16, 16);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            ItemStack wrapped = GhostIngredientHandler.wrapDraggedItem(this.type, ingredient);
            if (wrapped != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new InventoryActionPacket(InventoryAction.SET_FILTER, this.slot.index, wrapped), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

