/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.kitchen;

import java.util.Collection;
import java.util.List;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record CombinedKitchenItemProvider(List<KitchenItemProvider> providers) implements KitchenItemProvider
{
    @Override
    public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        if (cacheHint instanceof CacheHintWrapper) {
            Collection<IngredientToken> filteredIngredientTokens;
            CacheHintWrapper wrapper = (CacheHintWrapper)cacheHint;
            KitchenItemProvider provider = this.providers.get(wrapper.providerIndex);
            IngredientToken token = provider.findIngredient(ingredient, filteredIngredientTokens = this.getFilteredIngredientTokens(ingredientTokens, wrapper.providerIndex), wrapper.cacheHint);
            if (token != null) {
                return new IngredientTokenWrapper(wrapper.providerIndex, token);
            }
            return null;
        }
        for (int i = 0; i < this.providers.size(); ++i) {
            CacheHint cacheHint2;
            KitchenItemProvider provider = this.providers.get(i);
            Collection<IngredientToken> filteredIngredientTokens = this.getFilteredIngredientTokens(ingredientTokens, i);
            if (cacheHint instanceof CacheHintWrapper) {
                CacheHintWrapper wrapper = (CacheHintWrapper)cacheHint;
                cacheHint2 = wrapper.cacheHint;
            } else {
                cacheHint2 = cacheHint;
            }
            CacheHint unwrappedCacheHint = cacheHint2;
            IngredientToken token = provider.findIngredient(ingredient, filteredIngredientTokens, unwrappedCacheHint);
            if (token == null) continue;
            return new IngredientTokenWrapper(i, token);
        }
        return null;
    }

    @Override
    public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        if (cacheHint instanceof CacheHintWrapper) {
            CacheHintWrapper wrapper = (CacheHintWrapper)cacheHint;
            KitchenItemProvider provider = this.providers.get(wrapper.providerIndex);
            IngredientToken token = provider.findIngredient(itemStack, ingredientTokens, wrapper.cacheHint);
            if (token != null) {
                return new IngredientTokenWrapper(wrapper.providerIndex, token);
            }
            return null;
        }
        for (int i = 0; i < this.providers.size(); ++i) {
            CacheHint cacheHint2;
            KitchenItemProvider provider = this.providers.get(i);
            Collection<IngredientToken> filteredIngredientTokens = this.getFilteredIngredientTokens(ingredientTokens, i);
            if (cacheHint instanceof CacheHintWrapper) {
                CacheHintWrapper wrapper = (CacheHintWrapper)cacheHint;
                cacheHint2 = wrapper.cacheHint;
            } else {
                cacheHint2 = cacheHint;
            }
            CacheHint unwrappedCacheHint = cacheHint2;
            IngredientToken token = provider.findIngredient(itemStack, filteredIngredientTokens, unwrappedCacheHint);
            if (token == null) continue;
            return new IngredientTokenWrapper(i, token);
        }
        return null;
    }

    @Override
    public CacheHint getCacheHint(IngredientToken ingredientToken) {
        if (ingredientToken instanceof IngredientTokenWrapper) {
            IngredientTokenWrapper wrapper = (IngredientTokenWrapper)ingredientToken;
            KitchenItemProvider provider = this.providers.get(wrapper.providerIndex);
            CacheHint cacheHint = provider.getCacheHint(wrapper.token);
            return new CacheHintWrapper(wrapper.providerIndex, cacheHint);
        }
        return CacheHint.NONE;
    }

    private Collection<IngredientToken> getFilteredIngredientTokens(Collection<IngredientToken> ingredientTokens, int providerIndex) {
        return ingredientTokens.stream().filter(ingredientToken -> {
            if (!(ingredientToken instanceof IngredientTokenWrapper)) return false;
            IngredientTokenWrapper wrapper = (IngredientTokenWrapper)ingredientToken;
            if (wrapper.providerIndex != providerIndex) return false;
            return true;
        }).map(ingredientToken -> ((IngredientTokenWrapper)ingredientToken).token).toList();
    }

    private record CacheHintWrapper(int providerIndex, CacheHint cacheHint) implements CacheHint
    {
    }

    private record IngredientTokenWrapper(int providerIndex, IngredientToken token) implements IngredientToken
    {
        @Override
        public ItemStack peek() {
            return this.token.peek();
        }

        @Override
        public ItemStack consume() {
            return this.token.consume();
        }

        @Override
        public ItemStack restore(ItemStack itemStack) {
            return this.token.restore(itemStack);
        }
    }
}

