/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.KitchenOperation;
import net.blay09.mods.cookingforblockheads.crafting.CraftingOperation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class CraftingContext {
    @Nullable
    private final Player player;
    private final List<KitchenItemProvider> itemProviders;
    private final List<KitchenItemProcessor> itemProcessors;
    private final Map<IntList, Integer> cachedProviderIndexByIngredient = new HashMap<IntList, Integer>();
    private final Map<CraftingOperation.IngredientTokenKey, CacheHint> cacheHintsByIngredient = new HashMap<CraftingOperation.IngredientTokenKey, CacheHint>();
    private final List<Consumer<KitchenOperation>> listeners = new ArrayList<Consumer<KitchenOperation>>();

    public CraftingContext(Kitchen kitchen, @Nullable Player player) {
        this.player = player;
        this.itemProviders = kitchen.getItemProviders(player);
        this.itemProcessors = kitchen.getItemProcessors();
    }

    public CraftingOperation createOperation(RecipeHolder<Recipe<?>> recipe) {
        return new CraftingOperation(this, recipe);
    }

    public List<KitchenItemProvider> getItemProviders() {
        return this.itemProviders;
    }

    public List<KitchenItemProcessor> getItemProcessors() {
        return this.itemProcessors;
    }

    public int getCachedItemProviderIndexFor(Ingredient ingredient) {
        return this.cachedProviderIndexByIngredient.getOrDefault(ingredient.getStackingIds(), -1);
    }

    public CacheHint getCacheHintFor(CraftingOperation.IngredientTokenKey ingredientTokenKey) {
        return this.cacheHintsByIngredient.getOrDefault(ingredientTokenKey, CacheHint.NONE);
    }

    public void cache(CraftingOperation.IngredientTokenKey ingredientTokenKey, int itemProviderIndex, CacheHint cacheHint) {
        this.cacheHintsByIngredient.put(ingredientTokenKey, cacheHint);
        this.cachedProviderIndexByIngredient.put(ingredientTokenKey.stackingIds(), itemProviderIndex);
    }

    public void addListener(Consumer<KitchenOperation> listener) {
        this.listeners.add(listener);
    }

    public void notify(KitchenOperation operation) {
        for (Consumer<KitchenOperation> listener : this.listeners) {
            listener.accept(operation);
        }
    }

    public ItemStack restore(ItemStack itemStack) {
        if (this.player != null && !this.player.addItem(itemStack)) {
            this.player.drop(itemStack, true);
            return ItemStack.EMPTY;
        }
        return itemStack;
    }
}

