/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util.xray;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.thevortex.potionsmaster.render.util.BlockInfo;
import com.thevortex.potionsmaster.render.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.lwjgl.opengl.GL11;

public class Render {
    @OnlyIn(value=Dist.CLIENT)
    public static final Render INSTANCE = new Render();
    private static RenderType XRAY_TYPE = null;
    private VertexBuffer vertexBuf = null;
    private final AtomicBoolean dataAvailable = new AtomicBoolean(false);
    public static OreList ores = new OreList();

    public static RenderType buildRenderType() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeLinesShader)).setCullState(new RenderStateShard.CullStateShard(false)).setTransparencyState(new RenderStateShard.TransparencyStateShard("xray", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> RenderSystem.disableBlend())).createCompositeState(true);
        return RenderType.create((String)"xray", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)512, (boolean)false, (boolean)false, (RenderType.CompositeState)compositeState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void rebuildBuffer() {
        PoseStack stack = new PoseStack();
        Tesselator tesselator = new Tesselator(XRAY_TYPE.bufferSize() * Render.ores.oreList.size());
        BufferBuilder builder = tesselator.begin(XRAY_TYPE.mode(), XRAY_TYPE.format());
        for (BlockInfo b : Render.ores.oreList) {
            if (b == null) continue;
            Render.renderShape(stack, (VertexConsumer)builder, Shapes.block(), b.getX(), b.getY(), b.getZ(), b.color);
        }
        VertexBuffer vbuf = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        vbuf.bind();
        vbuf.upload(builder.build());
        if (this.vertexBuf != null) {
            this.vertexBuf.close();
        }
        this.vertexBuf = vbuf;
        VertexBuffer.unbind();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOres(RenderLevelStageEvent event) {
        if (XRAY_TYPE == null) {
            try {
                XRAY_TYPE = Render.buildRenderType();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.dataAvailable.get()) {
            this.rebuildBuffer();
            this.dataAvailable.set(false);
        }
        if (this.vertexBuf == null) {
            return;
        }
        Minecraft thisInstance = Minecraft.getInstance();
        Vec3 view = thisInstance.gameRenderer.getMainCamera().getPosition();
        PoseStack stack = event.getPoseStack();
        stack.pushPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthFunc((int)519);
        stack.mulPose(event.getModelViewMatrix());
        stack.translate(-view.x, -view.y, -view.z);
        Profile.BLOCKS.apply();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        this.vertexBuf.bind();
        ShaderInstance thisRenderer = GameRenderer.getPositionColorShader();
        assert (thisRenderer != null);
        thisRenderer.COLOR_MODULATOR.set(0.0f);
        this.vertexBuf.drawWithShader(stack.last().pose(), event.getProjectionMatrix(), RenderSystem.getShader());
        VertexBuffer.unbind();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        stack.popPose();
        RenderSystem.applyModelViewMatrix();
        Profile.BLOCKS.clean();
    }

    public static void renderShape(PoseStack pose, VertexConsumer vcon, VoxelShape shape, double x, double y, double z, int color) {
        PoseStack.Pose posestack$pose = pose.last();
        float[] col = Util.getComponents(color);
        shape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            float f = (float)(x2 - x1);
            float f1 = (float)(y2 - y1);
            float f2 = (float)(z2 - z1);
            float f3 = Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
            vcon.addVertex(posestack$pose, (float)(x1 + x), (float)(y1 + y), (float)(z1 + z)).setColor(col[0], col[1], col[2], col[3]).setNormal(f /= f3, f1 /= f3, f2 /= f3);
            vcon.addVertex(posestack$pose, (float)(x2 + x), (float)(y2 + y), (float)(z2 + z)).setColor(col[0], col[1], col[2], col[3]).setNormal(f, f1, f2);
        });
    }

    public static class OreList {
        protected List<BlockInfo> oreList = Collections.synchronizedList(new ArrayList());

        public void add(BlockInfo info) {
            this.oreList.add(info);
            Render.INSTANCE.dataAvailable.set(true);
        }

        public void remove(BlockInfo info) {
            this.oreList.remove((Object)info);
            Render.INSTANCE.dataAvailable.set(true);
        }

        public boolean isEmpty() {
            return this.oreList.isEmpty();
        }

        public void clear() {
            this.oreList.clear();
            Render.INSTANCE.dataAvailable.set(true);
        }

        public void addAll(Collection<? extends BlockInfo> list) {
            this.oreList.addAll(list);
            Render.INSTANCE.dataAvailable.set(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static enum Profile {
        BLOCKS{

            @Override
            public void apply() {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)2848);
                GL11.glDisable((int)2929);
                RenderSystem.lineWidth((float)6.0f);
            }

            @Override
            public void clean() {
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2848);
            }
        }
        ,
        ENTITIES{

            @Override
            public void apply() {
            }

            @Override
            public void clean() {
            }
        };


        public abstract void apply();

        public abstract void clean();
    }
}

