/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import de.melanx.extradisks.Registration;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class StorageContainerUpgradeRecipe
extends ShapelessRecipe {
    private final Ingredient baseDisk;
    private final Ingredient part;

    public StorageContainerUpgradeRecipe(Ingredient baseDisk, Ingredient part, ItemStack result) {
        super("", CraftingBookCategory.MISC, result, NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{baseDisk, part}));
        this.baseDisk = baseDisk;
        this.part = part;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput input, @Nonnull HolderLookup.Provider provider) {
        for (int i = 0; i < input.size(); ++i) {
            ItemStack fromDisk = input.getItem(i);
            Item item = fromDisk.getItem();
            if (!(item instanceof UpgradeableStorageContainer)) continue;
            UpgradeableStorageContainer from = (UpgradeableStorageContainer)item;
            ItemStack toDisk = this.getResultItem(provider).copy();
            from.transferTo(fromDisk, toDisk);
            return toDisk;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainingItems = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < input.size(); ++i) {
            UpgradeableStorageContainer from;
            Item storagePart;
            ItemStack fromDisk = input.getItem(i);
            Item item = fromDisk.getItem();
            if (!(item instanceof UpgradeableStorageContainer) || (storagePart = (from = (UpgradeableStorageContainer)item).getVariant().getStoragePart()) == null) continue;
            remainingItems.set(i, (Object)new ItemStack((ItemLike)storagePart));
        }
        return remainingItems;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registration.UPGRADE_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<StorageContainerUpgradeRecipe> {
        private static final MapCodec<StorageContainerUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("base_disk").forGetter(recipe -> recipe.baseDisk), (App)Ingredient.CODEC_NONEMPTY.fieldOf("storage_part").forGetter(recipe -> recipe.part), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, StorageContainerUpgradeRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, StorageContainerUpgradeRecipe> STREAM_CODEC = StreamCodec.of((buffer, recipe) -> {
            Ingredient.CONTENTS_STREAM_CODEC.encode(buffer, (Object)recipe.baseDisk);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buffer, (Object)recipe.part);
            ItemStack.STREAM_CODEC.encode(buffer, (Object)recipe.result);
        }, buffer -> new StorageContainerUpgradeRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buffer), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buffer), (ItemStack)ItemStack.STREAM_CODEC.decode(buffer)));

        @Nonnull
        public MapCodec<StorageContainerUpgradeRecipe> codec() {
            return CODEC;
        }

        @Nonnull
        public StreamCodec<RegistryFriendlyByteBuf, StorageContainerUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

