/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item.component;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public interface SizeProvider {
    public static final BiMap<String, MapCodec<? extends SizeProvider>> REGISTRY = HashBiMap.create(Map.of("modify_factor", ModifyFactor.CODEC, "set_base", SetBase.CODEC, "modify_base", ModifyBase.CODEC));
    public static final Codec<SizeProvider> CODEC = Codec.STRING.dispatch(t -> (String)REGISTRY.inverse().get(t.codec()), arg_0 -> REGISTRY.get(arg_0));

    default public float applyBaseModifier(float source) {
        return source;
    }

    default public float applyFactorModifier(float source) {
        return source;
    }

    public Component getTooltip(Component var1);

    public MapCodec<? extends SizeProvider> codec();

    public static int calculate(IItemHandler upgrades, Supplier<DataComponentType<SizeProvider>> component, int baseIn, ItemStack[] replacements) {
        return (int)Math.floor(SizeProvider.calculateAsFactor(upgrades, component, baseIn, replacements));
    }

    public static int calculate(IItemHandler upgrades, Supplier<DataComponentType<SizeProvider>> component, int baseIn) {
        return (int)Math.floor(SizeProvider.calculateAsFactor(upgrades, component, baseIn));
    }

    public static float calculateAsFactor(IItemHandler upgrades, Supplier<DataComponentType<SizeProvider>> component, float baseIn) {
        return SizeProvider.calculateAsFactor(upgrades, component, baseIn, new ItemStack[upgrades.getSlots()]);
    }

    public static float calculateAsFactor(IItemHandler upgrades, Supplier<DataComponentType<SizeProvider>> component, float baseIn, ItemStack[] replacements) {
        float factor = 1.0f;
        float base = baseIn;
        for (int i = 0; i < upgrades.getSlots(); ++i) {
            SizeProvider comp;
            ItemStack stack = Objects.requireNonNullElse(replacements[i], upgrades.getStackInSlot(i));
            if (stack.isEmpty() || (comp = (SizeProvider)stack.get(component)) == null) continue;
            factor = comp.applyFactorModifier(factor);
            base = comp.applyBaseModifier(base);
        }
        factor = Math.max(factor, 0.0f);
        base = Math.max(base, 0.0f);
        float result = base * factor;
        return (float)(Math.floor(result * 100.0f) / 100.0);
    }

    public record ModifyFactor(float factor) implements SizeProvider
    {
        private static final DecimalFormat TWO_DECIMALS = new DecimalFormat("#0.00");
        public static final MapCodec<ModifyFactor> CODEC = Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("factor").xmap(ModifyFactor::new, ModifyFactor::factor);

        @Override
        public float applyFactorModifier(float source) {
            return source * this.factor;
        }

        @Override
        public Component getTooltip(Component object) {
            if (this.factor < 1.0f) {
                return Component.translatable((String)"storageupgrade.desc.modify_factor_div", (Object[])new Object[]{object, ModifyFactor.format(1.0f / this.factor)});
            }
            return Component.translatable((String)"storageupgrade.desc.modify_factor_mult", (Object[])new Object[]{object, ModifyFactor.format(this.factor)});
        }

        private static String format(float value) {
            if (Integer.valueOf((int)value).floatValue() == value) {
                return String.valueOf((int)value);
            }
            return TWO_DECIMALS.format(value);
        }

        @Override
        public MapCodec<? extends SizeProvider> codec() {
            return CODEC;
        }
    }

    public record SetBase(float amount) implements SizeProvider
    {
        public static final MapCodec<SetBase> CODEC = Codec.withAlternative((Codec)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), (Codec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).xmap(Integer::floatValue, Float::intValue)).fieldOf("amount").xmap(SetBase::new, SetBase::amount);

        public SetBase(int amount) {
            this((float)amount);
        }

        @Override
        public float applyBaseModifier(float source) {
            return this.amount;
        }

        @Override
        public Component getTooltip(Component object) {
            return Component.translatable((String)"storageupgrade.desc.set_base", (Object[])new Object[]{object, Float.valueOf(this.amount)});
        }

        @Override
        public MapCodec<? extends SizeProvider> codec() {
            return CODEC;
        }
    }

    public record ModifyBase(float amount) implements SizeProvider
    {
        public static final MapCodec<ModifyBase> CODEC = Codec.withAlternative((Codec)Codec.FLOAT, (Codec)Codec.INT.xmap(Integer::floatValue, Float::intValue)).fieldOf("amount").xmap(ModifyBase::new, ModifyBase::amount);

        public ModifyBase(int amount) {
            this((float)amount);
        }

        @Override
        public float applyBaseModifier(float source) {
            return source + this.amount;
        }

        @Override
        public Component getTooltip(Component object) {
            return this.amount < 0.0f ? Component.translatable((String)"storageupgrade.desc.modify_base_dec", (Object[])new Object[]{object, Float.valueOf(-this.amount)}) : Component.translatable((String)"storageupgrade.desc.modify_base_inc", (Object[])new Object[]{object, Float.valueOf(this.amount)});
        }

        @Override
        public MapCodec<? extends SizeProvider> codec() {
            return CODEC;
        }
    }
}

