/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.compat.top;

import com.buuz135.functionalstorage.util.Utils;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CustomElementItemStack
implements IElement {
    public static ResourceLocation RL = Utils.resourceLocation("functionalstorage", "drawer_element");
    private final ItemStack itemStack;
    private final IItemStyle style;
    private final String display;
    private boolean displayName;

    public CustomElementItemStack(ItemStack itemStack, String display, IItemStyle style) {
        this.itemStack = itemStack;
        this.style = style;
        this.display = display;
        this.displayName = false;
    }

    public CustomElementItemStack(ItemStack itemStack, String display, IItemStyle style, boolean displayName) {
        this(itemStack, display, style);
        this.displayName = true;
    }

    public CustomElementItemStack(RegistryFriendlyByteBuf buf) {
        this.itemStack = buf.readBoolean() ? NetworkTools.readItemStack((RegistryFriendlyByteBuf)buf) : ItemStack.EMPTY;
        this.style = new ItemStyle().width(buf.readInt()).height(buf.readInt());
        this.display = buf.readUtf();
        this.displayName = buf.readBoolean();
    }

    public void render(GuiGraphics matrixStack, int x, int y) {
        ItemRenderer itemRender = Minecraft.getInstance().getItemRenderer();
        if (!this.itemStack.isEmpty()) {
            if (!RenderHelper.renderItemStack((Minecraft)Minecraft.getInstance(), (ItemRenderer)itemRender, (ItemStack)this.itemStack, (GuiGraphics)matrixStack, (int)(x + (this.style.getWidth() - 18) / 2), (int)(y + (this.style.getHeight() - 18) / 2), (String)this.display)) {
                Minecraft var10000 = Minecraft.getInstance();
                ChatFormatting var10004 = ChatFormatting.RED;
                RenderHelper.renderText((Minecraft)var10000, (GuiGraphics)matrixStack, (int)x, (int)y, (String)(String.valueOf(var10004) + "ERROR: " + String.valueOf(this.itemStack.getHoverName())));
            }
            if (this.displayName) {
                RenderHelper.renderText((Minecraft)Minecraft.getInstance(), (GuiGraphics)matrixStack, (int)(x + 22), (int)(y + 7), (Component)this.itemStack.getHoverName());
            }
        }
    }

    public int getWidth() {
        return this.style.getWidth() + (this.displayName ? Minecraft.getInstance().font.width(this.itemStack.getHoverName().getString()) : 0);
    }

    public int getHeight() {
        return this.style.getHeight();
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        if (!this.itemStack.isEmpty()) {
            buf.writeBoolean(true);
            NetworkTools.writeItemStack((RegistryFriendlyByteBuf)buf, (ItemStack)this.itemStack);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.writeUtf(this.display);
        buf.writeBoolean(this.displayName);
    }

    public ResourceLocation getID() {
        return RL;
    }
}

