/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.FramedBlock;
import com.buuz135.functionalstorage.block.tile.DrawerTile;
import com.buuz135.functionalstorage.block.tile.FramedDrawerTile;
import com.buuz135.functionalstorage.client.model.FramedDrawerModelData;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.recipe.CopyComponentsRecipe;
import com.buuz135.functionalstorage.util.DrawerWoodType;
import com.buuz135.functionalstorage.util.Utils;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.HashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;

public class FramedDrawerBlock
extends DrawerBlock
implements FramedBlock {
    public FramedDrawerBlock(FunctionalStorage.DrawerType type) {
        super(DrawerWoodType.FRAMED, type, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion().isViewBlocking((p_61036_, p_61037_, p_61038_) -> false));
    }

    @Override
    public BlockEntityType.BlockEntitySupplier<DrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> new FramedDrawerTile((BasicTileBlock<DrawerTile>)this, (BlockEntityType<DrawerTile>)((BlockEntityType)FunctionalStorage.DRAWER_TYPES.get((Object)this.getType()).stream().filter(registryObjectRegistryObjectPair -> registryObjectRegistryObjectPair.getBlock() == this).map(BlockWithTile::type).findFirst().get().get()), blockPos, state, this.getType());
    }

    public static FramedDrawerModelData getDrawerModelData(ItemStack stack) {
        if (stack.has(FSAttachments.STYLE)) {
            CompoundTag tag = (CompoundTag)stack.getOrDefault(FSAttachments.STYLE, (Object)new CompoundTag());
            if (tag.isEmpty()) {
                return null;
            }
            HashMap<String, Item> data = new HashMap<String, Item>();
            data.put("particle", (Item)BuiltInRegistries.ITEM.get(Utils.resourceLocation(tag.getString("particle"))));
            data.put("front", (Item)BuiltInRegistries.ITEM.get(Utils.resourceLocation(tag.getString("front"))));
            data.put("side", (Item)BuiltInRegistries.ITEM.get(Utils.resourceLocation(tag.getString("side"))));
            data.put("front_divider", (Item)BuiltInRegistries.ITEM.get(Utils.resourceLocation(tag.getString("front_divider"))));
            return new FramedDrawerModelData(data);
        }
        return null;
    }

    public static ItemStack fill(ItemStack first, ItemStack second, ItemStack drawer, ItemStack divider) {
        drawer = drawer.copyWithCount(1);
        CompoundTag style = (CompoundTag)drawer.getOrDefault(FSAttachments.STYLE, (Object)new CompoundTag());
        style.putString("particle", BuiltInRegistries.ITEM.getKey((Object)first.getItem()).toString());
        style.putString("side", BuiltInRegistries.ITEM.getKey((Object)first.getItem()).toString());
        style.putString("front", BuiltInRegistries.ITEM.getKey((Object)second.getItem()).toString());
        if (divider.isEmpty()) {
            style.putString("front_divider", BuiltInRegistries.ITEM.getKey((Object)first.getItem()).toString());
        } else {
            style.putString("front_divider", BuiltInRegistries.ITEM.getKey((Object)divider.getItem()).toString());
        }
        drawer.set(FSAttachments.STYLE, (Object)style);
        return drawer;
    }

    @Override
    public void registerRecipe(RecipeOutput consumer) {
        if (this.getType() == FunctionalStorage.DrawerType.X_1) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PPP").pattern("PCP").pattern("PPP").define(Character.valueOf('P'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            this.simpleToFramed(consumer, TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PPP").pattern("PCP").pattern("PPP").define(Character.valueOf('P'), Tags.Items.NUGGETS_IRON));
        } else if (this.getType() == FunctionalStorage.DrawerType.X_2) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)2).pattern("PCP").pattern("PPP").pattern("PCP").define(Character.valueOf('P'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            this.simpleToFramed(consumer, TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern(" P ").pattern("PCP").pattern(" P ").define(Character.valueOf('P'), Tags.Items.NUGGETS_IRON));
        } else if (this.getType() == FunctionalStorage.DrawerType.X_4) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)4).pattern("CPC").pattern("PPP").pattern("CPC").define(Character.valueOf('P'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            this.simpleToFramed(consumer, TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PCP").define(Character.valueOf('P'), Tags.Items.NUGGETS_IRON), 1);
        }
    }

    private void simpleToFramed(RecipeOutput output, ShapedRecipeBuilder recipe, int copyIndex) {
        recipe.define(Character.valueOf('C'), DifferenceIngredient.of((Ingredient)Ingredient.of(this.getType().getTag()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{this}))).save(CopyComponentsRecipe.output(output, copyIndex, FSAttachments.TILE.get()), ((ResourceKey)this.builtInRegistryHolder().unwrapKey().get()).location().withSuffix("_from_simple"));
    }

    private void simpleToFramed(RecipeOutput output, ShapedRecipeBuilder recipe) {
        this.simpleToFramed(output, recipe, 4);
    }
}

