/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codecs.YRangeAllowance;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class MineshaftStructure
extends GenericJigsawStructure {
    public static final MapCodec<MineshaftStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MineshaftStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)YRangeAllowance.CODEC.optionalFieldOf("y_allowance").forGetter(structure -> structure.yAllowance), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.CODEC.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)StringRepresentable.fromEnum(GenericJigsawStructure.BURYING_TYPE::values).optionalFieldOf("burying_type").forGetter(structure -> structure.buryingType), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, MineshaftStructure::new));

    public MineshaftStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<YRangeAllowance> yAllowance, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<GenericJigsawStructure.BURYING_TYPE> buryingType, boolean useBoundingBoxHack, LiquidSettings liquidSettings) {
        super(config, startPool, size, yAllowance, startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, poolsThatIgnoreBoundaries, maxDistanceFromCenter, buryingType, useBoundingBoxHack, liquidSettings);
    }

    @Override
    protected void postLayoutAdjustments(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context, int offsetY, BlockPos blockpos, int topClipOff, int bottomClipOff, List<PoolElementStructurePiece> pieces) {
        int justBelowTerrain = MineshaftStructure.getTerrainHeight(context.chunkPos().getMiddleBlockPosition(0), context) - 15;
        int finalJustBelowTerrain = Math.max(justBelowTerrain, bottomClipOff);
        Optional<PoolElementStructurePiece> topPiece = pieces.stream().max(Comparator.comparingInt(piece -> piece.getBoundingBox().maxY()));
        if (topPiece.isPresent() && finalJustBelowTerrain < topClipOff && finalJustBelowTerrain < topPiece.get().getBoundingBox().maxY()) {
            int topPieceMaxY = topPiece.get().getBoundingBox().maxY();
            pieces.forEach(piece -> GeneralUtils.movePieceProperly((StructurePiece)piece, 0, finalJustBelowTerrain - topPieceMaxY, 0));
        }
    }

    private static int getTerrainHeight(BlockPos centerPos, Structure.GenerationContext context) {
        int height = GeneralUtils.getCachedFreeHeight(context.chunkGenerator(), centerPos.getX(), centerPos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState()) - 1;
        BlockPos pos = new BlockPos(centerPos.getX(), 0, centerPos.getZ());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.set((Vec3i)pos).move(direction, 16);
            height = Math.min(height, GeneralUtils.getCachedFreeHeight(context.chunkGenerator(), mutable.getX(), mutable.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState())) - 1;
        }
        return height;
    }

    @Override
    public StructureType<?> type() {
        return RSStructures.GENERIC_MINESHAFT.get();
    }
}

