/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MineshaftSkyViewProcessor
extends StructureProcessor {
    public static final MapCodec<MineshaftSkyViewProcessor> CODEC = MapCodec.unit(MineshaftSkyViewProcessor::new);

    private MineshaftSkyViewProcessor() {
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.state().is(Blocks.RAIL) && worldView.getBlockState(structureBlockInfoWorld.pos().below()).canOcclude()) {
            boolean waterlogged = worldView.getBlockState(structureBlockInfoWorld.pos()).getFluidState().is(FluidTags.WATER);
            return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), (BlockState)structureBlockInfoWorld.state().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), structureBlockInfoWorld.nbt());
        }
        if (structureBlockInfoWorld.pos().getY() >= worldView.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, structureBlockInfoWorld.pos().getX(), structureBlockInfoWorld.pos().getZ())) {
            return null;
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.MINESHAFT_SKY_VIEW_PROCESSOR.get();
    }
}

