/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class AirProcessor
extends StructureProcessor {
    public static final MapCodec<AirProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf("ignore_block").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(config -> config.blocksToIgnore)).apply((Applicative)instance, instance.stable(AirProcessor::new)));
    private final HashSet<Block> blocksToIgnore;

    private AirProcessor(HashSet<Block> blocksToIgnore) {
        this.blocksToIgnore = blocksToIgnore;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.state().isAir()) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(structureBlockInfoWorld.pos()))) {
                return structureBlockInfoWorld;
            }
            BlockPos currentPos = structureBlockInfoWorld.pos();
            ChunkAccess currentChunk = levelReader.getChunk(currentPos);
            if (currentPos.getY() >= currentChunk.getMinBuildHeight() && currentPos.getY() < currentChunk.getMaxBuildHeight() && !this.blocksToIgnore.contains(currentChunk.getBlockState(currentPos).getBlock())) {
                int sectionYIndex;
                LevelChunkSection levelChunkSection;
                LevelHeightAccessor levelHeightAccessor = currentChunk.getHeightAccessorForGeneration();
                if (levelReader instanceof WorldGenLevel && currentPos.getY() >= levelHeightAccessor.getMinBuildHeight() && currentPos.getY() < levelHeightAccessor.getMaxBuildHeight() && (levelChunkSection = currentChunk.getSection(sectionYIndex = currentChunk.getSectionIndex(currentPos.getY()))) != null) {
                    levelChunkSection.setBlockState(SectionPos.sectionRelative((int)currentPos.getX()), SectionPos.sectionRelative((int)currentPos.getY()), SectionPos.sectionRelative((int)currentPos.getZ()), structureBlockInfoWorld.state(), false);
                }
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.AIR_PROCESSOR.get();
    }
}

