/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WitherSkeletonWithBow
extends Feature<NoneFeatureConfiguration> {
    public WitherSkeletonWithBow() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos position = context.origin().below();
        WitherSkeleton witherEntity = (WitherSkeleton)EntityType.WITHER_SKELETON.create((Level)context.level().getLevel());
        witherEntity.setPersistenceRequired();
        witherEntity.moveTo((double)position.getX() + 0.5, (double)position.getY(), (double)position.getZ() + 0.5, 0.0f, 0.0f);
        witherEntity.getAttribute(Attributes.FOLLOW_RANGE).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"random_spawn_bonus"), context.random().nextGaussian() * 0.3 + 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        ItemStack bow = new ItemStack((ItemLike)Items.BOW);
        Registry enchantmentRegistry = context.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        bow.enchant((Holder)enchantmentRegistry.getHolderOrThrow(Enchantments.FLAME), 1);
        bow.enchant((Holder)enchantmentRegistry.getHolderOrThrow(Enchantments.PUNCH), 2);
        bow.enchant((Holder)enchantmentRegistry.getHolderOrThrow(Enchantments.POWER), 2);
        bow.enchant((Holder)enchantmentRegistry.getHolderOrThrow(Enchantments.VANISHING_CURSE), 1);
        bow.enchant((Holder)enchantmentRegistry.getHolderOrThrow(Enchantments.BINDING_CURSE), 1);
        witherEntity.setItemInHand(InteractionHand.MAIN_HAND, bow);
        witherEntity.setDropChance(EquipmentSlot.MAINHAND, 0.5f);
        witherEntity.setLeftHanded(context.random().nextFloat() < 0.05f);
        context.level().addFreshEntityWithPassengers((Entity)witherEntity);
        return true;
    }
}

