/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class SimpleBlockWithFluidTick
extends Feature<SimpleBlockConfiguration> {
    public SimpleBlockWithFluidTick(Codec<SimpleBlockConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        SimpleBlockConfiguration simpleBlockConfiguration = (SimpleBlockConfiguration)context.config();
        WorldGenLevel worldGenLevel = context.level();
        BlockPos blockPos = context.origin();
        BlockState blockState = simpleBlockConfiguration.toPlace().getState(context.random(), blockPos);
        if (!blockState.canSurvive((LevelReader)worldGenLevel, blockPos)) {
            return false;
        }
        if (blockState.getBlock() instanceof DoublePlantBlock) {
            if (!worldGenLevel.isEmptyBlock(blockPos.above())) {
                return false;
            }
            DoublePlantBlock.placeAt((LevelAccessor)worldGenLevel, (BlockState)blockState, (BlockPos)blockPos, (int)2);
            return true;
        }
        worldGenLevel.setBlock(blockPos, blockState, 2);
        if (!blockState.getFluidState().isEmpty()) {
            worldGenLevel.scheduleTick(blockPos, blockState.getFluidState().getType(), 0);
        }
        return true;
    }
}

