/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.storage.advancedstorageblock;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.storage.StorageNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockData;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockEntity;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainerImpl;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import edivad.extrastorage.storage.advancedstorageblock.AdvancedStorageBlockContainerMenu;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedStorageBlockBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<StorageNetworkNode>
implements NetworkNodeExtendedMenuProvider<StorageBlockData>,
StorageBlockEntity,
AbstractStorageContainerNetworkNode.Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvancedStorageBlockBlockEntity.class);
    private static final String TAG_STORAGE_ID = "sid";
    protected final StorageConfigurationContainerImpl configContainer;
    private final FilterWithFuzzyMode filter;
    private final Component displayName;
    private final StorageBlockProvider storageBlockProvider;
    @Nullable
    private UUID storageId;

    public AdvancedStorageBlockBlockEntity(BlockPos pos, BlockState state, StorageBlockProvider provider) {
        super(provider.getBlockEntityType(), pos, state, (AbstractNetworkNode)new StorageNetworkNode(provider.getEnergyUsage(), 0L, 1));
        this.filter = FilterWithFuzzyMode.createAndListenForUniqueFilters((ResourceContainer)ResourceContainerImpl.createForFilter((ResourceFactory)provider.getResourceFactory()), () -> ((AdvancedStorageBlockBlockEntity)this).setChanged(), this::setFilters);
        this.configContainer = new StorageConfigurationContainerImpl(((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration(), this.filter, () -> ((AdvancedStorageBlockBlockEntity)this).setChanged(), () -> ((AdvancedStorageBlockBlockEntity)this).getRedstoneMode(), arg_0 -> ((AdvancedStorageBlockBlockEntity)this).setRedstoneMode(arg_0));
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setNormalizer(this.filter.createNormalizer());
        this.displayName = provider.getDisplayName();
        this.storageBlockProvider = provider;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide()) {
            return;
        }
        if (this.storageId == null) {
            this.storageId = UUID.randomUUID();
            StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(level);
            SerializableStorage storage = this.storageBlockProvider.createStorage(() -> ((StorageRepository)storageRepository).markAsChanged());
            storageRepository.set(this.storageId, storage);
        }
        ((StorageNetworkNode)this.mainNetworkNode).setProvider((AbstractStorageContainerNetworkNode.Provider)this);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_STORAGE_ID)) {
            this.setStorageId(tag.getUUID(TAG_STORAGE_ID));
        }
        super.loadAdditional(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.configContainer.load(tag);
        this.filter.load(tag, provider);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.storageId != null) {
            tag.putUUID(TAG_STORAGE_ID, this.storageId);
        }
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.configContainer.save(tag);
        this.filter.save(tag, provider);
    }

    public void setStorageId(UUID storageId) {
        this.tryRemoveCurrentStorage(storageId);
        this.storageId = storageId;
        ((StorageNetworkNode)this.mainNetworkNode).onStorageChanged(0);
    }

    private void tryRemoveCurrentStorage(UUID newStorageId) {
        if (this.level == null || this.storageId == null || this.storageId.equals(newStorageId)) {
            return;
        }
        LOGGER.info("Updating storage ID from {} to {}. Removing old storage", (Object)this.storageId, (Object)newStorageId);
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(this.level);
        storageRepository.removeIfEmpty(this.storageId).ifPresentOrElse(storage -> LOGGER.info("Storage {} successfully removed", (Object)this.storageId), () -> LOGGER.warn("Storage {} could not be removed", (Object)this.storageId));
    }

    void setFilters(Set<ResourceKey> filters) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilters(filters);
    }

    void setFilterMode(FilterMode mode) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilterMode(mode);
        this.setChanged();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    void setAccessMode(AccessMode accessMode) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setAccessMode(accessMode);
    }

    void setVoidExcess(boolean voidExcess) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setVoidExcess(voidExcess);
    }

    @Nullable
    public UUID getStorageId() {
        return this.storageId;
    }

    protected final ResourceContainer getFilterContainer() {
        return this.filter.getFilterContainer();
    }

    public StorageBlockData getMenuData() {
        return new StorageBlockData(((StorageNetworkNode)this.mainNetworkNode).getStored(), ((StorageNetworkNode)this.mainNetworkNode).getCapacity(), ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer()).resources());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, StorageBlockData> getMenuCodec() {
        return RefinedStorageApi.INSTANCE.getStorageBlockDataStreamCodec();
    }

    public Optional<Storage> resolve(int index) {
        if (this.level == null || this.storageId == null) {
            return Optional.empty();
        }
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(this.level);
        return storageRepository.get(this.storageId).map(Storage.class::cast);
    }

    public Component getName() {
        return this.overrideName(this.displayName);
    }

    public AdvancedStorageBlockContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new AdvancedStorageBlockContainerMenu(this.storageBlockProvider.getMenuType(), syncId, player, this.filter.getFilterContainer(), (StorageConfigurationContainer)this.configContainer, p -> Container.stillValidBlockEntity((BlockEntity)this, (Player)p));
    }
}

