/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.storage.advancedstorageblock;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerBlockItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import edivad.extrastorage.setup.ESItems;
import edivad.extrastorage.storage.AdvancedFluidStorageVariant;
import edivad.extrastorage.storage.advancedstorageblock.AdvancedStorageBlock;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedFluidStorageBlockBlockItem
extends AbstractStorageContainerBlockItem
implements UpgradeableStorageContainer {
    private final AdvancedFluidStorageVariant variant;
    private final Component helpText;

    public AdvancedFluidStorageBlockBlockItem(AdvancedStorageBlock<?> block, AdvancedFluidStorageVariant variant) {
        super(block, new Item.Properties().stacksTo(1).fireResistant(), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = IdentifierUtil.createTranslation((String)"item", (String)"fluid_storage_block.help", (Object[])new Object[]{IdentifierUtil.format((long)variant.getCapacityInBuckets())});
    }

    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    protected String formatAmount(long amount) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(FluidResource.class).formatAmount(amount);
    }

    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return AdvancedFluidStorageBlockBlockItem.createStorage(this.variant, () -> ((StorageRepository)storageRepository).markAsChanged());
    }

    static SerializableStorage createStorage(AdvancedFluidStorageVariant variant, Runnable listener) {
        return StorageTypes.FLUID.create(variant.getCapacity(), listener);
    }

    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Blocks.INSTANCE.getMachineCasing(), count);
    }

    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)ESItems.FLUID_STORAGE_PART.get((Object)this.variant).get(), count);
    }

    protected boolean placeBlock(BlockPlaceContext ctx, BlockState state) {
        ServerPlayer serverPlayer;
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer && !RefinedStorageApi.INSTANCE.canPlaceNetworkNode(serverPlayer = (ServerPlayer)player, ctx.getLevel(), ctx.getClickedPos(), state)) {
            return false;
        }
        return super.placeBlock(ctx, state);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    public StorageVariant getVariant() {
        return this.variant;
    }

    public void transferTo(ItemStack from, ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

