/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.autocrafting.advancedautocrafter;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.autocrafting.PatternSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockMode;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import edivad.extrastorage.ExtraStorage;
import edivad.extrastorage.autocrafting.advancedautocrafter.AdvancedAutocrafterContainerMenu;
import edivad.extrastorage.autocrafting.advancedautocrafter.AutocrafterPrioritySideButtonWidget;
import edivad.extrastorage.autocrafting.advancedautocrafter.AutocrafterPropertyTypes;
import edivad.extrastorage.autocrafting.advancedautocrafter.CrafterTier;
import edivad.extrastorage.autocrafting.advancedautocrafter.LockModeSideButtonWidget;
import edivad.extrastorage.autocrafting.advancedautocrafter.VisibleToTheAutocrafterManagerSideButtonWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AdvancedAutocrafterScreen
extends AbstractBaseScreen<AdvancedAutocrafterContainerMenu>
implements AdvancedAutocrafterContainerMenu.Listener,
PatternOutputRenderingScreen {
    private static final Component EMPTY_PATTERN_SLOT = IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"autocrafter.empty_pattern_slot");
    private static final Component CHAINED = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.chained");
    private static final Component CHAINED_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.chained.help");
    private static final Component CHAINED_HEAD_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.chained.head_help");
    private static final Component NOT_CHAINED = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.not_chained");
    private static final Component NOT_CHAINED_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.not_chained.help");
    private static final Component EDIT = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.edit_name");
    private static final Component CURRENTLY_LOCKED = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.currently_locked");
    private static final ResourceLocation NAME_BACKGROUND = IdentifierUtil.createIdentifier((String)"widget/autocrafter_name");
    private static final List<String> CRAFTER_NAME_HISTORY = new ArrayList<String>();
    private final Inventory playerInventory;
    @Nullable
    private LockModeSideButtonWidget lockModeSideButtonWidget;
    @Nullable
    private EditBox nameField;
    @Nullable
    private Button editButton;
    private boolean editName;
    private final CrafterTier tier;
    private final ResourceLocation texture;

    public AdvancedAutocrafterScreen(AdvancedAutocrafterContainerMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, new TextMarquee(title, AdvancedAutocrafterScreen.getTitleMaxWidth(menu)));
        this.imageWidth = 211;
        this.imageHeight = 173 + menu.getTier().ordinal() * 36;
        this.inventoryLabelY = this.imageHeight - 94;
        this.playerInventory = inventory;
        this.tier = menu.getTier();
        this.texture = ExtraStorage.rl("textures/gui/" + this.tier.getID() + ".png");
    }

    private static int getTitleMaxWidth(AdvancedAutocrafterContainerMenu menu) {
        int chainingTitleWidth = Minecraft.getInstance().font.width((FormattedText)AdvancedAutocrafterScreen.getChainingTitle(menu));
        int editButtonWidth = AdvancedAutocrafterScreen.getEditButtonWidth();
        return 162 - chainingTitleWidth - editButtonWidth - 10;
    }

    private int getEditButtonX() {
        return this.leftPos + this.titleLabelX + this.titleMarquee.getEffectiveWidth(this.font) + 2;
    }

    private static int getEditButtonWidth() {
        return Minecraft.getInstance().font.width((FormattedText)EDIT) + 8;
    }

    private static Component getChainingTitle(AdvancedAutocrafterContainerMenu menu) {
        return menu.isPartOfChain() || menu.isHeadOfChain() ? CHAINED : NOT_CHAINED;
    }

    private Component getChainingTooltip() {
        if (!((AdvancedAutocrafterContainerMenu)this.getMenu()).isPartOfChain() && !((AdvancedAutocrafterContainerMenu)this.getMenu()).isHeadOfChain()) {
            return NOT_CHAINED_HELP;
        }
        return ((AdvancedAutocrafterContainerMenu)this.getMenu()).isHeadOfChain() ? CHAINED_HEAD_HELP : CHAINED_HELP;
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (this.imageHeight <= 256) {
            graphics.blit(this.texture, x, y, 0, 0, this.imageWidth, this.imageHeight);
        } else {
            graphics.blit(this.texture, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        }
        this.renderResourceSlots(graphics);
        if (this.editName) {
            graphics.blitSprite(NAME_BACKGROUND, this.leftPos + 7, this.topPos + 5, 162, 12);
        }
    }

    protected void init() {
        super.init();
        ((AdvancedAutocrafterContainerMenu)this.getMenu()).setListener(this);
        this.tryAddLockModeSideButton();
        this.addSideButton(new AutocrafterPrioritySideButtonWidget((ClientProperty<Integer>)((AdvancedAutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.PRIORITY), this.playerInventory, (Screen)this));
        this.addSideButton((AbstractSideButtonWidget)new VisibleToTheAutocrafterManagerSideButtonWidget((ClientProperty<Boolean>)((AdvancedAutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER)));
        this.nameField = new SearchFieldWidget(this.font, this.leftPos + 8 + 1, this.topPos + 6 + 1, 153, new History(CRAFTER_NAME_HISTORY));
        this.nameField.setValue(this.title.getString());
        this.nameField.setBordered(false);
        this.nameField.setCanLoseFocus(false);
        this.addWidget((GuiEventListener)this.nameField);
        this.editButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)EDIT, button -> this.setEditName(true)).pos(this.getEditButtonX(), this.topPos + this.titleLabelY - 3).size(AdvancedAutocrafterScreen.getEditButtonWidth(), 14).build());
        this.editButton.active = ((AdvancedAutocrafterContainerMenu)this.getMenu()).canChangeName();
        this.setEditName(false);
    }

    private void tryAddLockModeSideButton() {
        if (((AdvancedAutocrafterContainerMenu)this.getMenu()).isPartOfChain()) {
            return;
        }
        this.lockModeSideButtonWidget = new LockModeSideButtonWidget((ClientProperty<LockMode>)((AdvancedAutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.LOCK_MODE));
        this.lockedChanged(((AdvancedAutocrafterContainerMenu)this.getMenu()).isLocked());
        this.addSideButton(this.lockModeSideButtonWidget);
    }

    private void setEditName(boolean editName) {
        this.editName = editName;
        if (this.nameField != null) {
            this.nameField.visible = editName;
            this.nameField.setFocused(editName);
            this.nameField.setCanLoseFocus(!editName);
            if (editName) {
                this.setFocused((GuiEventListener)this.nameField);
            } else {
                this.setFocused(null);
            }
        }
        if (this.editButton != null) {
            this.editButton.visible = !editName;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.nameField != null && this.editName) {
            this.nameField.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.editName) {
            this.renderPlayerInventoryTitle(graphics);
            return;
        }
        super.renderLabels(graphics, mouseX, mouseY);
        Component title = AdvancedAutocrafterScreen.getChainingTitle((AdvancedAutocrafterContainerMenu)this.menu);
        graphics.drawString(this.font, title, this.getChainingTitleX(title), this.titleLabelY, 0x404040, false);
    }

    private int getChainingTitleX(Component title) {
        return this.imageWidth - 41 - this.font.width((FormattedText)title);
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.nameField != null && this.editName && this.nameField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.nameField != null && this.editName) {
            if (this.nameField.isFocused() && this.saveOrCancel(key)) {
                return true;
            }
            return this.nameField.keyPressed(key, scanCode, modifiers);
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    private boolean saveOrCancel(int key) {
        if (key == 257 || key == 335) {
            ((AdvancedAutocrafterContainerMenu)this.getMenu()).changeName(Objects.requireNonNull(this.nameField).getValue());
            this.setEditName(false);
            return true;
        }
        if (key == 256) {
            this.setEditName(false);
            Objects.requireNonNull(this.nameField).setValue(this.titleMarquee.getText().getString());
            return true;
        }
        return false;
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        PatternSlot patternSlot;
        Slot slot = this.hoveredSlot;
        if (slot instanceof PatternSlot && !(patternSlot = (PatternSlot)slot).hasItem() && ((AdvancedAutocrafterContainerMenu)this.getMenu()).getCarried().isEmpty()) {
            graphics.renderTooltip(this.font, EMPTY_PATTERN_SLOT, x, y);
            return;
        }
        Component chainingTitle = AdvancedAutocrafterScreen.getChainingTitle((AdvancedAutocrafterContainerMenu)this.getMenu());
        int chainingTitleX = this.getChainingTitleX(chainingTitle);
        int n = this.font.width((FormattedText)chainingTitle);
        Objects.requireNonNull(this.font);
        if (this.isHovering(chainingTitleX, this.titleLabelY, n, 9, x, y)) {
            Component chainingTooltip = this.getChainingTooltip();
            Platform.INSTANCE.renderTooltip(graphics, List.of(HelpClientTooltipComponent.createAlwaysDisplayed((Component)chainingTooltip)), x, y);
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    protected ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public void nameChanged(Component name) {
        this.titleMarquee.setText(name);
        if (this.nameField != null) {
            this.nameField.setValue(name.getString());
        }
        if (this.editButton != null) {
            this.editButton.setX(this.getEditButtonX());
        }
    }

    @Override
    public void lockedChanged(boolean locked) {
        if (this.lockModeSideButtonWidget == null) {
            return;
        }
        if (locked) {
            this.lockModeSideButtonWidget.setWarning(CURRENTLY_LOCKED);
            return;
        }
        this.lockModeSideButtonWidget.setWarning(null);
    }

    public boolean canDisplayOutput(ItemStack stack) {
        return ((AdvancedAutocrafterContainerMenu)this.getMenu()).containsPattern(stack);
    }
}

