/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.autocrafting.advancedautocrafter;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskImpl;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.ParentContainer;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.ExternalPatternSinkKeyProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderListener;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterBlockEntity;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockMode;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import edivad.extrastorage.autocrafting.advancedautocrafter.AdvancedAutocrafterContainerMenu;
import edivad.extrastorage.autocrafting.advancedautocrafter.AutocrafterConnectionStrategy;
import edivad.extrastorage.autocrafting.advancedautocrafter.AutocrafterNetworkNodeContainer;
import edivad.extrastorage.autocrafting.advancedautocrafter.AutocrafterParentContainer;
import edivad.extrastorage.autocrafting.advancedautocrafter.CrafterTier;
import edivad.extrastorage.autocrafting.advancedautocrafter.LockModeSettings;
import edivad.extrastorage.autocrafting.advancedautocrafter.TaskSnapshotPersistence;
import edivad.extrastorage.setup.ESBlockEntities;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedAutocrafterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<PatternProviderNetworkNode>
implements ExtendedMenuProvider<AutocrafterData>,
BlockEntityWithDrops,
PatternInventory.Listener,
StepBehavior,
ExternalPatternSinkKeyProvider,
PatternProviderExternalPatternSink,
PatternProviderListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvancedAutocrafterBlockEntity.class);
    private static final int MAX_CHAINED_AUTOCRAFTERS = 8;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_PATTERNS = "patterns";
    private static final String TAG_LOCK_MODE = "lm";
    private static final String TAG_PRIORITY = "pri";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER = "vaum";
    private static final String TAG_LOCKED = "locked";
    private static final String TAG_WAS_POWERED = "wp";
    private final PatternInventory patternContainer;
    private final UpgradeContainer upgradeContainer;
    private LockMode lockMode = LockMode.NEVER;
    private boolean visibleToTheAutocrafterManager = true;
    private int ticks;
    private int steps;
    private int tickRate = AdvancedAutocrafterBlockEntity.getTickRate(0);
    @Nullable
    private PlatformPatternProviderExternalPatternSink sink;
    @Nullable
    private ExternalPatternSinkKey sinkKey;
    private boolean wasPowered;
    private boolean locked;
    private final CrafterTier tier;

    public AdvancedAutocrafterBlockEntity(CrafterTier tier, BlockPos pos, BlockState state) {
        super((BlockEntityType)ESBlockEntities.CRAFTER.get((Object)tier).get(), pos, state, (AbstractNetworkNode)new PatternProviderNetworkNode(Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage(), tier.getSlots()));
        this.tier = tier;
        this.steps = AdvancedAutocrafterBlockEntity.getSteps(tier, 0);
        this.patternContainer = new PatternInventory(this.tier.getSlots(), () -> ((AdvancedAutocrafterBlockEntity)this).getLevel());
        this.upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.AUTOCRAFTER, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage();
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((PatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            int amountOfSpeedUpgrades = c.getAmount((UpgradeItem)Items.INSTANCE.getSpeedUpgrade());
            this.tickRate = AdvancedAutocrafterBlockEntity.getTickRate(amountOfSpeedUpgrades);
            this.steps = AdvancedAutocrafterBlockEntity.getSteps(tier, amountOfSpeedUpgrades);
            this.setChanged();
        });
        this.patternContainer.addListener(container -> {
            long upgradeEnergyUsage = this.upgradeContainer.getEnergyUsage();
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage();
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((PatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            this.setChanged();
        });
        this.patternContainer.setListener((PatternInventory.Listener)this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setStepBehavior((StepBehavior)this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setSinkKeyProvider((ExternalPatternSinkKeyProvider)this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setSink((PatternProviderExternalPatternSink)this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setListener((PatternProviderListener)this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).onAddedIntoContainer((ParentContainer)new AutocrafterParentContainer(this));
    }

    protected InWorldNetworkNodeContainer createMainContainer(PatternProviderNetworkNode networkNode) {
        return new AutocrafterNetworkNodeContainer(this, (NetworkNode)networkNode, "main", (ConnectionStrategy)new AutocrafterConnectionStrategy(() -> ((AdvancedAutocrafterBlockEntity)this).getBlockState(), this.getBlockPos()));
    }

    public FilteredContainer getPatternContainer() {
        return this.patternContainer;
    }

    private boolean isPartOfChain() {
        return this.getChainingRoot() != this;
    }

    private boolean isHeadOfChain() {
        if (this.level == null || this.isPartOfChain()) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            AutocrafterBlockEntity neighborAutocrafter;
            Direction neighborDirection;
            BlockEntity neighbor;
            BlockPos pos = this.getBlockPos().relative(direction);
            if (!this.level.isLoaded(pos) || !((neighbor = this.level.getBlockEntity(pos)) instanceof AutocrafterBlockEntity) || (neighborDirection = AbstractDirectionalBlock.tryExtractDirection((BlockState)(neighborAutocrafter = (AutocrafterBlockEntity)neighbor).getBlockState())) != direction.getOpposite()) continue;
            return true;
        }
        return false;
    }

    private AdvancedAutocrafterBlockEntity getChainingRoot() {
        return this.getChainingRoot(0, this);
    }

    private AdvancedAutocrafterBlockEntity getChainingRoot(int depth, AdvancedAutocrafterBlockEntity origin) {
        Direction direction = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.getBlockState());
        if (this.level == null || direction == null || depth >= 8) {
            return origin;
        }
        BlockEntity neighbor = this.getConnectedMachine();
        if (!(neighbor instanceof AdvancedAutocrafterBlockEntity)) {
            return this;
        }
        AdvancedAutocrafterBlockEntity neighborCrafter = (AdvancedAutocrafterBlockEntity)neighbor;
        return neighborCrafter.getChainingRoot(depth + 1, origin);
    }

    @Nullable
    private BlockEntity getConnectedMachine() {
        Direction direction = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.getBlockState());
        if (this.level == null || direction == null) {
            return null;
        }
        BlockPos neighborPos = this.getBlockPos().relative(direction);
        if (!this.level.isLoaded(neighborPos)) {
            return null;
        }
        return this.level.getBlockEntity(neighborPos);
    }

    public Component getName() {
        AdvancedAutocrafterBlockEntity root = this.getChainingRoot();
        if (root == this) {
            return this.doGetName();
        }
        return root.getName();
    }

    private Component doGetName() {
        Component customName = this.getCustomName();
        if (customName != null) {
            return customName;
        }
        BlockEntity connectedMachine = this.getConnectedMachine();
        if (connectedMachine instanceof Nameable) {
            Nameable nameable = (Nameable)connectedMachine;
            if (!(connectedMachine instanceof AdvancedAutocrafterBlockEntity)) {
                return nameable.getName();
            }
        }
        if (connectedMachine != null) {
            return connectedMachine.getBlockState().getBlock().getName();
        }
        return this.getBlockState().getBlock().getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new AdvancedAutocrafterContainerMenu(windowId, inventory, this, this.tier);
    }

    public AutocrafterData getMenuData() {
        return new AutocrafterData(this.isPartOfChain(), this.isHeadOfChain(), this.locked);
    }

    public StreamEncoder<RegistryFriendlyByteBuf, AutocrafterData> getMenuCodec() {
        return AutocrafterData.STREAM_CODEC;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_PATTERNS, (Tag)ContainerUtil.write((Container)this.patternContainer, (HolderLookup.Provider)provider));
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, (HolderLookup.Provider)provider));
        tag.putBoolean(TAG_LOCKED, this.locked);
        tag.putBoolean(TAG_WAS_POWERED, this.wasPowered);
        ListTag tasks = new ListTag();
        for (Task task : ((PatternProviderNetworkNode)this.mainNetworkNode).getTasks()) {
            if (!(task instanceof TaskImpl)) continue;
            TaskImpl taskImpl = (TaskImpl)task;
            try {
                tasks.add((Object)TaskSnapshotPersistence.encodeSnapshot(taskImpl.createSnapshot()));
            }
            catch (Exception e) {
                LOGGER.error("Error while saving task {} {}", new Object[]{task.getResource(), task.getAmount(), e});
            }
        }
        tag.put(TAG_TASKS, (Tag)tasks);
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt(TAG_LOCK_MODE, LockModeSettings.getLockMode(this.lockMode));
        tag.putInt(TAG_PRIORITY, ((PatternProviderNetworkNode)this.mainNetworkNode).getPriority());
        tag.putBoolean(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, this.visibleToTheAutocrafterManager);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_PATTERNS)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_PATTERNS), (Container)this.patternContainer, (HolderLookup.Provider)provider);
        }
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, (HolderLookup.Provider)provider);
        }
        if (tag.contains(TAG_TASKS)) {
            ListTag tasks = tag.getList(TAG_TASKS, 10);
            for (int i = 0; i < tasks.size(); ++i) {
                CompoundTag taskTag = tasks.getCompound(i);
                try {
                    TaskSnapshot snapshot = TaskSnapshotPersistence.decodeSnapshot(taskTag);
                    ((PatternProviderNetworkNode)this.mainNetworkNode).addTask((Task)new TaskImpl(snapshot));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error while loading task, skipping", (Throwable)e);
                }
            }
        }
        if (tag.contains(TAG_LOCKED)) {
            this.locked = tag.getBoolean(TAG_LOCKED);
        }
        if (tag.contains(TAG_WAS_POWERED)) {
            this.wasPowered = tag.getBoolean(TAG_WAS_POWERED);
        }
        super.loadAdditional(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_LOCK_MODE)) {
            this.lockMode = LockModeSettings.getLockMode(tag.getInt(TAG_LOCK_MODE));
        }
        if (tag.contains(TAG_PRIORITY)) {
            ((PatternProviderNetworkNode)this.mainNetworkNode).setPriority(tag.getInt(TAG_PRIORITY));
        }
        if (tag.contains(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER)) {
            this.visibleToTheAutocrafterManager = tag.getBoolean(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER);
        }
    }

    protected boolean hasRedstoneMode() {
        return false;
    }

    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        drops.addAll((Collection)this.upgradeContainer.getDrops());
        for (int i = 0; i < this.patternContainer.getContainerSize(); ++i) {
            drops.add((Object)this.patternContainer.getItem(i));
        }
        return drops;
    }

    public void setCustomName(String name) {
        if (this.isPartOfChain()) {
            return;
        }
        this.setCustomName((Component)(name.trim().isBlank() ? null : Component.literal((String)name)));
        this.setChanged();
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        this.locked = false;
        this.wasPowered = false;
        this.setChanged();
    }

    public int getPriority() {
        return ((PatternProviderNetworkNode)this.mainNetworkNode).getPriority();
    }

    public void setPriority(int priority) {
        ((PatternProviderNetworkNode)this.mainNetworkNode).setPriority(priority);
        this.setChanged();
    }

    public void setVisibleToTheAutocrafterManager(boolean visibleToTheAutocrafterManager) {
        this.visibleToTheAutocrafterManager = visibleToTheAutocrafterManager;
        this.setChanged();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide()) {
            return;
        }
        for (int i = 0; i < this.patternContainer.getContainerSize(); ++i) {
            this.patternChanged(i);
        }
    }

    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        this.invalidateSinkKey();
        this.sink = RefinedStorageApi.INSTANCE.getPatternProviderExternalPatternSinkFactory().create(level, sourcePosition, incomingDirection);
    }

    public void patternChanged(int slot) {
        if (this.level == null) {
            return;
        }
        Pattern pattern = RefinedStorageApi.INSTANCE.getPattern(this.patternContainer.getItem(slot), this.level).orElse(null);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setPattern(slot, pattern);
    }

    public void doWork() {
        super.doWork();
        if (((PatternProviderNetworkNode)this.mainNetworkNode).isActive()) {
            ++this.ticks;
        }
        this.updateLocked();
    }

    private void updateLocked() {
        boolean newLocked = this.calculateLocked();
        if (newLocked != this.locked) {
            this.setLocked(newLocked);
        }
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
        this.setChanged();
    }

    private boolean calculateLocked() {
        if (this.level == null) {
            return false;
        }
        return switch (this.lockMode) {
            default -> throw new MatchException(null, null);
            case LockMode.NEVER -> false;
            case LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED -> this.isLockedInPulseMode();
            case LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY -> {
                if (this.sink != null && !this.sink.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED -> this.locked;
            case LockMode.LOCK_UNTIL_HIGH_REDSTONE_SIGNAL -> {
                if (!this.level.hasNeighborSignal(this.worldPosition)) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_LOW_REDSTONE_SIGNAL -> this.level.hasNeighborSignal(this.worldPosition);
        };
    }

    private boolean isLockedInPulseMode() {
        if (this.level != null && this.level.hasNeighborSignal(this.worldPosition)) {
            this.wasPowered = true;
            this.setChanged();
        } else if (this.wasPowered) {
            this.wasPowered = false;
            this.setChanged();
            return false;
        }
        return this.locked;
    }

    public boolean canStep(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return false;
        }
        if (provider == this.mainNetworkNode) {
            return ((PatternProviderNetworkNode)this.mainNetworkNode).isActive() && this.ticks % this.tickRate == 0;
        }
        return provider.canStep(pattern);
    }

    public int getSteps(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return 0;
        }
        if (provider == this.mainNetworkNode) {
            return this.steps;
        }
        return provider.getSteps(pattern);
    }

    private static int getSteps(CrafterTier tier, int amountOfSpeedUpgrades) {
        if (tier.equals((Object)CrafterTier.IRON)) {
            return amountOfSpeedUpgrades + tier.getCraftingSpeed();
        }
        return amountOfSpeedUpgrades * (tier.getCraftingSpeed() / 5) + tier.getCraftingSpeed();
    }

    private static int getTickRate(int amountOfSpeedUpgrades) {
        return 10 - amountOfSpeedUpgrades * 2;
    }

    @Nullable
    private PatternProvider lookupProvider(Pattern pattern) {
        Network network = ((PatternProviderNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return null;
        }
        return ((AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class)).getProviderByPattern(pattern);
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((BlockState)oldBlockState, (BlockState)newBlockState);
    }

    @Nullable
    public ExternalPatternSinkKey getKey() {
        if (this.sinkKey == null) {
            this.tryUpdateSinkKey();
        }
        return this.sinkKey;
    }

    private void tryUpdateSinkKey() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Direction direction = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.getBlockState());
        if (direction == null) {
            return;
        }
        AdvancedAutocrafterBlockEntity root = this.getChainingRoot();
        BlockEntity connectedMachine = root.getConnectedMachine();
        if (connectedMachine == null) {
            this.invalidateSinkKey();
            return;
        }
        BlockState connectedMachineState = connectedMachine.getBlockState();
        Player fakePlayer = this.getFakePlayer(serverLevel);
        ItemStack connectedMachineStack = Platform.INSTANCE.getBlockAsItemStack(connectedMachineState.getBlock(), connectedMachineState, direction.getOpposite(), (LevelReader)serverLevel, connectedMachine.getBlockPos(), fakePlayer);
        this.sinkKey = new InWorldExternalPatternSinkKey(this.getName().getString(), connectedMachineStack);
    }

    private void invalidateSinkKey() {
        this.sinkKey = null;
    }

    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        AdvancedAutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            return root.accept(resources, action);
        }
        if (this.sink == null) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        if (this.locked) {
            return ExternalPatternSink.Result.LOCKED;
        }
        ExternalPatternSink.Result result = this.sink.accept(resources, action);
        this.updateLockedAfterAccept(action, result);
        return result;
    }

    private void updateLockedAfterAccept(Action action, ExternalPatternSink.Result result) {
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && this.lockMode == LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY) {
            this.updateLocked();
        }
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && (this.lockMode == LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED || this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED)) {
            this.setLocked(true);
        }
    }

    public void receivedExternalIteration() {
        AdvancedAutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            root.receivedExternalIteration();
            return;
        }
        if (this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED && this.locked) {
            this.setLocked(false);
        }
    }

    @Generated
    public UpgradeContainer getUpgradeContainer() {
        return this.upgradeContainer;
    }

    @Generated
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Generated
    public boolean isVisibleToTheAutocrafterManager() {
        return this.visibleToTheAutocrafterManager;
    }

    @Generated
    public int getSteps() {
        return this.steps;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public CrafterTier getTier() {
        return this.tier;
    }
}

