/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetMBCS;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.UConverterStaticData;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.ICUBinary;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.InvalidFormatException;

final class UConverterDataReader {
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private int posAfterStaticData;
    private ByteBuffer byteBuffer;
    private static final int DATA_FORMAT_ID = 1668183668;

    protected UConverterDataReader(ByteBuffer bytes) throws IOException {
        this.byteBuffer = bytes;
        ICUBinary.readHeader(this.byteBuffer, 1668183668, IS_ACCEPTABLE);
    }

    protected void readStaticData(UConverterStaticData sd) throws IOException {
        sd.structSize = this.byteBuffer.getInt();
        byte[] name = new byte[60];
        this.byteBuffer.get(name);
        sd.name = new String(name, "US-ASCII");
        sd.codepage = this.byteBuffer.getInt();
        sd.platform = this.byteBuffer.get();
        sd.conversionType = this.byteBuffer.get();
        sd.minBytesPerChar = this.byteBuffer.get();
        sd.maxBytesPerChar = this.byteBuffer.get();
        this.byteBuffer.get(sd.subChar);
        sd.subCharLen = this.byteBuffer.get();
        sd.hasToUnicodeFallback = this.byteBuffer.get();
        sd.hasFromUnicodeFallback = this.byteBuffer.get();
        sd.unicodeMask = (short)(this.byteBuffer.get() & 0xFF);
        sd.subChar1 = this.byteBuffer.get();
        this.byteBuffer.get(sd.reserved);
        this.posAfterStaticData = this.byteBuffer.position();
    }

    int bytesReadAfterStaticData() {
        return this.byteBuffer.position() - this.posAfterStaticData;
    }

    protected void readMBCSHeader(CharsetMBCS.MBCSHeader h2) throws IOException {
        this.byteBuffer.get(h2.version);
        h2.countStates = this.byteBuffer.getInt();
        h2.countToUFallbacks = this.byteBuffer.getInt();
        h2.offsetToUCodeUnits = this.byteBuffer.getInt();
        h2.offsetFromUTable = this.byteBuffer.getInt();
        h2.offsetFromUBytes = this.byteBuffer.getInt();
        h2.flags = this.byteBuffer.getInt();
        h2.fromUBytesLength = this.byteBuffer.getInt();
        if (h2.version[0] == 5 && h2.version[1] >= 3) {
            h2.options = this.byteBuffer.getInt();
            if ((h2.options & 0x40) != 0) {
                h2.fullStage2Length = this.byteBuffer.getInt();
            }
        }
    }

    protected void readMBCSTable(CharsetMBCS.MBCSHeader header, CharsetMBCS.UConverterMBCSTable mbcsTable) throws IOException {
        block13: {
            block12: {
                boolean noFromU;
                int i2;
                IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
                mbcsTable.countStates = (byte)header.countStates;
                mbcsTable.stateTable = new int[header.countStates][256];
                for (i2 = 0; i2 < header.countStates; ++i2) {
                    intBuffer.get(mbcsTable.stateTable[i2]);
                }
                mbcsTable.countToUFallbacks = header.countToUFallbacks;
                mbcsTable.toUFallbacks = new CharsetMBCS.MBCSToUFallback[header.countToUFallbacks];
                for (i2 = 0; i2 < header.countToUFallbacks; ++i2) {
                    int offset = intBuffer.get();
                    int codePoint = intBuffer.get();
                    mbcsTable.toUFallbacks[i2] = new CharsetMBCS.MBCSToUFallback(offset, codePoint);
                }
                int length = intBuffer.position() * 4;
                ICUBinary.skipBytes(this.byteBuffer, length);
                CharBuffer charBuffer = this.byteBuffer.asCharBuffer();
                length = header.offsetFromUTable - header.offsetToUCodeUnits;
                assert ((length & 1) == 0);
                mbcsTable.unicodeCodeUnits = new char[length / 2];
                charBuffer.get(mbcsTable.unicodeCodeUnits);
                ICUBinary.skipBytes(this.byteBuffer, length);
                length = header.offsetFromUBytes - header.offsetFromUTable;
                assert ((length & 1) == 0);
                int fromUTableCharsLength = mbcsTable.outputType == 0 ? length / 2 : (mbcsTable.hasSupplementary() ? 1088 : 64);
                mbcsTable.fromUnicodeTable = new char[fromUTableCharsLength];
                charBuffer.get(mbcsTable.fromUnicodeTable);
                if (mbcsTable.outputType != 0) {
                    assert ((length & 3) == 0);
                    mbcsTable.fromUnicodeTableInts = new int[length / 4];
                    this.byteBuffer.asIntBuffer().get(mbcsTable.fromUnicodeTableInts);
                }
                ICUBinary.skipBytes(this.byteBuffer, length);
                mbcsTable.fromUBytesLength = header.fromUBytesLength;
                boolean bl = noFromU = (header.options & 0x40) != 0;
                if (noFromU) break block12;
                switch (mbcsTable.outputType) {
                    case 0: 
                    case 1: 
                    case 8: 
                    case 12: {
                        mbcsTable.fromUnicodeChars = ICUBinary.getChars(this.byteBuffer, header.fromUBytesLength / 2, 0);
                        break block13;
                    }
                    case 2: 
                    case 9: {
                        mbcsTable.fromUnicodeBytes = new byte[header.fromUBytesLength];
                        this.byteBuffer.get(mbcsTable.fromUnicodeBytes);
                        break block13;
                    }
                    case 3: {
                        mbcsTable.fromUnicodeInts = ICUBinary.getInts(this.byteBuffer, header.fromUBytesLength / 4, 0);
                        break block13;
                    }
                    default: {
                        assert (false);
                        break block13;
                    }
                }
            }
            mbcsTable.mbcsIndex = this.byteBuffer.asCharBuffer();
        }
    }

    protected String readBaseTableName() throws IOException {
        char c2;
        StringBuilder name = new StringBuilder();
        while ((c2 = (char)this.byteBuffer.get()) != '\u0000') {
            name.append(c2);
        }
        return name.toString();
    }

    protected ByteBuffer readExtIndexes(int skip) throws IOException, InvalidFormatException {
        ICUBinary.skipBytes(this.byteBuffer, skip);
        ByteBuffer b2 = ICUBinary.sliceWithOrder(this.byteBuffer);
        int lengthOfIndexes = b2.getInt(0);
        if (lengthOfIndexes < 32) {
            throw new InvalidFormatException();
        }
        int numBytesExtensionStructure = b2.getInt(124);
        b2.limit(numBytesExtensionStructure);
        ICUBinary.skipBytes(this.byteBuffer, numBytesExtensionStructure);
        return b2;
    }

    boolean dataFormatHasUnicodeMask() {
        int formatVersion0 = this.byteBuffer.get(16) & 0xFF;
        return formatVersion0 > 6 || formatVersion0 == 6 && this.byteBuffer.get(17) != 0;
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] formatVersion) {
            return formatVersion[0] == 6;
        }
    }
}

