/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.jniutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;

final class JNIExceptionWrapperEntryPoints {
    JNIExceptionWrapperEntryPoints() {
    }

    @JNIEntryPoint
    static Throwable updateStackTrace(Throwable target, byte[] serializedStackTrace) {
        Throwable throwable;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(serializedStackTrace));
        try {
            int len = in.readInt();
            StackTraceElement[] elements = new StackTraceElement[len];
            for (int i2 = 0; i2 < len; ++i2) {
                String className = in.readUTF();
                String methodName = in.readUTF();
                String fileName = in.readUTF();
                int lineNumber = in.readInt();
                elements[i2] = new StackTraceElement(className, methodName, fileName.isEmpty() ? null : fileName, lineNumber);
            }
            target.setStackTrace(elements);
            throwable = target;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        in.close();
        return throwable;
    }

    @JNIEntryPoint
    static Throwable createException(String message) {
        return new RuntimeException(message);
    }

    @JNIEntryPoint
    static byte[] getStackTrace(Throwable throwable) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(bout);){
            StackTraceElement[] stackTraceElements = throwable.getStackTrace();
            out.writeInt(stackTraceElements.length);
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                out.writeUTF(stackTraceElement.getClassName());
                out.writeUTF(stackTraceElement.getMethodName());
                String fileName = stackTraceElement.getFileName();
                out.writeUTF(fileName == null ? "" : fileName);
                out.writeInt(stackTraceElement.getLineNumber());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return bout.toByteArray();
    }

    @JNIEntryPoint
    static String getThrowableMessage(Throwable t2) {
        return t2.getMessage();
    }

    @JNIEntryPoint
    static String getClassName(Class<?> clz) {
        return clz.getName();
    }
}

