/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integratedscripting.IntegratedScripting;
import org.cyclops.integratedscripting.RegistryEntries;
import org.cyclops.integratedscripting.api.item.IScriptVariableFacade;
import org.cyclops.integratedscripting.api.network.IScriptingData;
import org.cyclops.integratedscripting.api.network.IScriptingNetwork;
import org.cyclops.integratedscripting.core.evaluate.ScriptVariableFacadeHandler;
import org.cyclops.integratedscripting.core.item.ScriptVariableFacade;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;
import org.cyclops.integratedscripting.network.packet.TerminalScriptingCreateNewScriptPacket;
import org.cyclops.integratedscripting.network.packet.TerminalScriptingDeleteScriptPacket;
import org.cyclops.integratedscripting.network.packet.TerminalScriptingModifiedScriptPacket;
import org.cyclops.integratedscripting.part.PartTypeTerminalScripting;

public class ContainerTerminalScripting
extends InventoryContainer
implements IDirtyMarkListener {
    public static Pattern INVALID_MEMBER_NAME = Pattern.compile("[^0-9a-zA-Z_]");
    public static Pattern VALID_MEMBER_NAME = Pattern.compile("[0-9a-zA-Z_]+");
    private final PartTarget target;
    private final Optional<IPartContainer> partContainer;
    private final PartTypeTerminalScripting partType;
    private final Level world;
    private final Optional<INetwork> network;
    private final Optional<IScriptingNetwork> scriptingNetwork;
    private final Set<Pair<Integer, Path>> clientScriptsDirty;
    private final Int2ObjectMap<Map<Path, String>> lastScripts = new Int2ObjectAVLTreeMap();
    private IntList availableDisks;
    private final int activeDiskId;
    private final int activeScriptPathId;
    private final int selectionId;

    public ContainerTerminalScripting(int id, Inventory playerInventory, RegistryFriendlyByteBuf packetBuffer) {
        this(id, playerInventory, PartHelpers.readPartTarget((RegistryFriendlyByteBuf)packetBuffer), Optional.empty(), (PartTypeTerminalScripting)PartHelpers.readPart((FriendlyByteBuf)packetBuffer), InitData.readFromPacketBuffer((FriendlyByteBuf)packetBuffer));
    }

    public ContainerTerminalScripting(int id, Inventory playerInventory, PartTarget target, Optional<IPartContainer> partContainer, PartTypeTerminalScripting partType, InitData initData) {
        super((MenuType)RegistryEntries.CONTAINER_TERMINAL_SCRIPTING.get(), id, playerInventory, (Container)new SimpleInventory(1, 1));
        ((SimpleInventory)this.getContainerInventory()).addDirtyMarkListener((IDirtyMarkListener)this);
        this.addSlot((Slot)new SlotVariable(this.getContainerInventory(), 0, 232, 137));
        this.addPlayerInventory(playerInventory, 88, 158);
        this.target = target;
        this.partType = partType;
        this.partContainer = partContainer;
        this.world = this.player.getCommandSenderWorld();
        this.network = NetworkHelpers.getNetwork((PartPos)this.getTarget().getCenter());
        this.scriptingNetwork = this.network.flatMap(ScriptingNetworkHelpers::getScriptingNetwork);
        this.clientScriptsDirty = Sets.newHashSet();
        this.availableDisks = initData.getAvailableDisks();
        this.activeDiskId = this.getNextValueId();
        this.setActiveDisk(this.availableDisks.isEmpty() ? -1 : this.availableDisks.getInt(0));
        this.activeScriptPathId = this.getNextValueId();
        this.selectionId = this.getNextValueId();
    }

    public Level getLevel() {
        return this.world;
    }

    public PartTypeTerminalScripting getPartType() {
        return this.partType;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public Optional<PartTypeTerminalScripting> getPartState() {
        return this.partContainer.map(p2 -> (PartTypeTerminalScripting)p2.getPartState(this.getTarget().getCenter().getSide()));
    }

    public Optional<IPartContainer> getPartContainer() {
        return this.partContainer;
    }

    public boolean stillValid(Player playerIn) {
        return PartHelpers.canInteractWith((PartTarget)this.getTarget(), (Player)this.player, (IPartContainer)this.partContainer.get());
    }

    public void removed(Player player) {
        ItemStack itemStack;
        super.removed(player);
        if (!player.level().isClientSide() && !(itemStack = this.getContainerInventory().getItem(0)).isEmpty()) {
            player.drop(itemStack, false);
        }
    }

    public Optional<INetwork> getNetwork() {
        return this.network;
    }

    public Optional<IScriptingNetwork> getScriptingNetwork() {
        return this.scriptingNetwork;
    }

    public IntList getAvailableDisks() {
        return this.availableDisks;
    }

    public int getActiveDisk() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.activeDiskId);
    }

    public void setActiveDisk(int activeDisk) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.activeDiskId, (int)activeDisk);
    }

    public Set<Pair<Integer, Path>> getClientScriptsDirty() {
        return this.clientScriptsDirty;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (!this.getLevel().isClientSide()) {
            this.getScriptingNetwork().ifPresent(scriptingNetwork -> {
                for (Integer disk : this.getAvailableDisks()) {
                    Set<Object> files;
                    Map<Path, String> scriptsNew = ScriptingNetworkHelpers.getScriptingData().getScripts(disk);
                    Map scriptsOld = (Map)this.lastScripts.get(disk.intValue());
                    if (scriptsOld == null) {
                        scriptsOld = Maps.newHashMap();
                        this.lastScripts.put(disk.intValue(), (Object)scriptsOld);
                        files = scriptsNew.keySet();
                    } else {
                        files = Sets.newHashSet(scriptsNew.keySet());
                        files.addAll(scriptsOld.keySet());
                    }
                    for (Path file : files) {
                        String scriptOld;
                        String scriptNew = scriptsNew.get(file);
                        if (Objects.equals(scriptNew, scriptOld = (String)scriptsOld.get(file))) continue;
                        if (scriptNew != null) {
                            IntegratedScripting._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalScriptingModifiedScriptPacket(disk, file, scriptNew), (ServerPlayer)this.player);
                        } else {
                            IntegratedScripting._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalScriptingDeleteScriptPacket(disk, file), (ServerPlayer)this.player);
                        }
                        if (scriptNew != null) {
                            scriptsOld.put(file, scriptNew);
                        } else {
                            scriptsOld.remove(file);
                        }
                        if (!scriptsOld.isEmpty()) continue;
                        this.lastScripts.remove(disk.intValue());
                    }
                }
            });
        }
    }

    protected int getSizeInventory() {
        return this.getContainerInventory().getContainerSize();
    }

    public void setLastScript(int disk, Path path, @Nullable String script) {
        Map lastScriptsDisk = (Map)this.lastScripts.get(disk);
        if (lastScriptsDisk == null) {
            lastScriptsDisk = Maps.newHashMap();
            this.lastScripts.put(disk, (Object)lastScriptsDisk);
        }
        if (script != null) {
            lastScriptsDisk.put(path, script);
        } else {
            lastScriptsDisk.remove(path);
        }
        if (lastScriptsDisk.isEmpty()) {
            this.lastScripts.remove(disk);
        }
    }

    public Int2ObjectMap<Map<Path, String>> getLastScripts() {
        return this.lastScripts;
    }

    public void setServerScript(int disk, Path path, @Nullable String script) {
        ScriptingNetworkHelpers.getScriptingData().setScript(disk, path, script, IScriptingData.ChangeLocation.MEMORY);
    }

    public void createNewServerScript(int disk) {
        Path path;
        Set<Path> existingScripts = ScriptingNetworkHelpers.getScriptingData().getScripts(disk).keySet();
        int i2 = 0;
        while (existingScripts.contains(path = Path.of("script" + i2++ + ".js", new String[0]))) {
        }
        ScriptingNetworkHelpers.getScriptingData().setScript(disk, path, "", IScriptingData.ChangeLocation.MEMORY);
    }

    @Nullable
    public Path getActiveScriptPath() {
        String str = ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.activeScriptPathId);
        return StringUtil.isNullOrEmpty((String)str) ? null : Path.of(str, new String[0]);
    }

    public void setActiveScriptPath(Path activeScriptPath) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.activeScriptPathId, (String)(activeScriptPath == null ? "" : activeScriptPath.toString()));
    }

    public String getSelectedMember() {
        int openBracketsPos;
        String str = ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.selectionId);
        if (str != null && (openBracketsPos = str.indexOf("(")) >= 0) {
            str = str.substring(0, openBracketsPos);
        }
        return str == null ? "" : str;
    }

    public void setSelection(String selection) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.selectionId, (String)selection);
    }

    public boolean isMemberSelected() {
        return VALID_MEMBER_NAME.matcher(this.getSelectedMember()).matches();
    }

    @Nullable
    public String getActiveScript() {
        Map diskScripts;
        Path path = this.getActiveScriptPath();
        int disk = this.getActiveDisk();
        if (path != null && disk >= 0 && (diskScripts = (Map)this.getLastScripts().get(disk)) != null) {
            return (String)diskScripts.get(path);
        }
        return null;
    }

    public void setActiveScript(String scriptNew) {
        String scriptOld;
        Map diskScripts;
        Path path = this.getActiveScriptPath();
        int disk = this.getActiveDisk();
        if (path != null && disk >= 0 && (diskScripts = (Map)this.getLastScripts().get(disk)) != null && !Objects.equals(scriptOld = diskScripts.put(path, scriptNew), scriptNew)) {
            this.clientScriptsDirty.add((Pair<Integer, Path>)Pair.of((Object)disk, (Object)path));
        }
    }

    public void createNewFile() {
        int disk = this.getActiveDisk();
        if (disk >= 0) {
            IntegratedScripting._instance.getPacketHandler().sendToServer((PacketBase)new TerminalScriptingCreateNewScriptPacket(disk));
        }
    }

    public List<MutableComponent> getReadErrors() {
        ArrayList list = Lists.newArrayList();
        if (this.canWriteScriptToVariable() && !this.isMemberSelected()) {
            list.add(Component.translatable((String)"gui.integratedscripting.error.invalid_member"));
            list.add(Component.translatable((String)"gui.integratedscripting.error.invalid_member.current", (Object[])new Object[]{this.getSelectedMember()}));
        }
        return list;
    }

    public boolean canWriteScriptToVariable() {
        return !this.getContainerInventory().getItem(0).isEmpty() && this.getActiveDisk() >= 0 && this.getActiveScriptPath() != null;
    }

    public void onDirty() {
        SimpleInventory writeInv = (SimpleInventory)this.getContainerInventory();
        ItemStack itemStack = writeInv.getItem(0);
        if (this.canWriteScriptToVariable() && !itemStack.isEmpty() && this.isMemberSelected()) {
            ItemStack outputStack = this.writeScriptVariable(!this.world.isClientSide, itemStack.copy(), this.getActiveDisk(), this.getActiveScriptPath(), this.getSelectedMember());
            writeInv.removeDirtyMarkListener((IDirtyMarkListener)this);
            writeInv.setItem(0, outputStack);
            writeInv.addDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    public ItemStack writeScriptVariable(boolean generateId, ItemStack itemStack, final int disk, final Path path, final String member) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, (IVariableFacadeHandler)ScriptVariableFacadeHandler.getInstance(), (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IScriptVariableFacade>(){

            public IScriptVariableFacade create(boolean generateId) {
                return new ScriptVariableFacade(generateId, disk, path, member);
            }

            public IScriptVariableFacade create(int id) {
                return new ScriptVariableFacade(id, disk, path, member);
            }
        }, this.getLevel(), this.player, ((Block)RegistryEntries.BLOCK_PART_TERMINAL_SCRIPTING.get()).defaultBlockState());
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (valueId == this.selectionId) {
            this.onDirty();
        }
    }

    public static class InitData {
        private final IntList availableDisks;

        public InitData(IntList availableDisks) {
            this.availableDisks = availableDisks;
        }

        public IntList getAvailableDisks() {
            return this.availableDisks;
        }

        public void writeToPacketBuffer(FriendlyByteBuf packetBuffer) {
            packetBuffer.writeIntIdList(this.getAvailableDisks());
        }

        public static InitData readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
            return new InitData(packetBuffer.readIntIdList());
        }
    }
}

