/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.runtime.OptimizedCallTarget;

public abstract class OptimizedFastThreadLocal
extends AbstractFastThreadLocal {
    protected OptimizedFastThreadLocal() {
    }

    @Override
    public abstract void set(Object[] var1);

    @Override
    public abstract Object[] get();

    @Override
    public final <C> C fastGet(int index, Class<C> castType, boolean invalidateOnNull, boolean nonNullResult) {
        if (CompilerDirectives.inCompiledCode()) {
            CompilerAsserts.partialEvaluationConstant(index);
            CompilerAsserts.partialEvaluationConstant(castType);
            Object[] array = this.get();
            if (array == null) {
                if (invalidateOnNull) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return null;
            }
            Object v2 = OptimizedCallTarget.castArrayFixedLength(array, index + 1)[index];
            C result = OptimizedCallTarget.unsafeCast(v2, castType, true, nonNullResult, true);
            return result;
        }
        Object[] data = this.get();
        if (data == null) {
            return null;
        }
        Object result = data[index];
        assert (castType == null || result == null || result.getClass() == castType) : "Invalid exact type returned";
        return (C)result;
    }
}

