/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public final class BitSets {
    public static int highByte(int c2) {
        return c2 >> 8;
    }

    public static int lowByte(int c2) {
        return c2 & 0xFF;
    }

    public static long[] createBitSetArray(int nbits) {
        return new long[BitSets.wordIndex(nbits - 1) + 1];
    }

    public static int wordIndex(int i2) {
        return i2 >> 6;
    }

    public static long toBit(int index) {
        return 1L << index;
    }

    public static boolean isEmpty(long[] bs) {
        for (long word : bs) {
            if (word == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isFull(long[] bs) {
        for (long word : bs) {
            if (word == -1L) continue;
            return false;
        }
        return true;
    }

    public static int size(long[] bs) {
        int ret = 0;
        for (long w2 : bs) {
            ret += Long.bitCount(w2);
        }
        return ret;
    }

    public static boolean get(long[] bs, int index) {
        return BitSets.wordIndex(index) < bs.length && (bs[BitSets.wordIndex(index)] & BitSets.toBit(index)) != 0L;
    }

    public static void set(long[] bs, int index) {
        int n2 = BitSets.wordIndex(index);
        bs[n2] = bs[n2] | BitSets.toBit(index);
    }

    public static boolean add(long[] bs, int index) {
        long old = bs[BitSets.wordIndex(index)];
        BitSets.set(bs, index);
        return bs[BitSets.wordIndex(index)] != old;
    }

    public static void setRange(long[] bs, int lo, int hi) {
        int wordIndexLo = BitSets.wordIndex(lo);
        int wordIndexHi = BitSets.wordIndex(hi);
        long rangeLo = -1L << lo;
        long rangeHi = -1L >>> 63 - (hi & 0x3F);
        if (wordIndexLo == wordIndexHi) {
            int n2 = wordIndexLo;
            bs[n2] = bs[n2] | rangeLo & rangeHi;
            return;
        }
        int n3 = wordIndexLo;
        bs[n3] = bs[n3] | rangeLo;
        for (int i2 = wordIndexLo + 1; i2 < wordIndexHi; ++i2) {
            bs[i2] = -1L;
        }
        int n4 = wordIndexHi;
        bs[n4] = bs[n4] | rangeHi;
    }

    public static void clearRange(long[] bs, int lo, int hi) {
        int wordIndexLo = BitSets.wordIndex(lo);
        int wordIndexHi = BitSets.wordIndex(hi);
        long rangeLo = -1L << lo;
        long rangeHi = -1L >>> 63 - (hi & 0x3F);
        if (wordIndexLo == wordIndexHi) {
            int n2 = wordIndexLo;
            bs[n2] = bs[n2] & (rangeLo & rangeHi ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int n3 = wordIndexLo;
        bs[n3] = bs[n3] & (rangeLo ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i2 = wordIndexLo + 1; i2 < wordIndexHi; ++i2) {
            bs[i2] = 0L;
        }
        int n4 = wordIndexHi;
        bs[n4] = bs[n4] & (rangeHi ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void clear(long[] bs) {
        Arrays.fill(bs, 0L);
    }

    public static void clear(long[] bs, int index) {
        int n2 = BitSets.wordIndex(index);
        bs[n2] = bs[n2] & (BitSets.toBit(index) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean remove(long[] bs, int index) {
        long old = bs[BitSets.wordIndex(index)];
        BitSets.clear(bs, index);
        return bs[BitSets.wordIndex(index)] != old;
    }

    public static void invert(long[] bs) {
        for (int i2 = 0; i2 < bs.length; ++i2) {
            bs[i2] = bs[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static long[] createInverse(long[] bs) {
        long[] ret = new long[bs.length];
        for (int i2 = 0; i2 < bs.length; ++i2) {
            ret[i2] = bs[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return ret;
    }

    public static void intersect(long[] bs1, long[] bs2) {
        int i2;
        for (i2 = 0; i2 < Math.min(bs1.length, bs2.length); ++i2) {
            int n2 = i2;
            bs1[n2] = bs1[n2] & bs2[i2];
        }
        while (i2 < bs1.length) {
            bs1[i2] = 0L;
            ++i2;
        }
    }

    public static int retainAll(long[] bs1, long[] bs2) {
        int i2;
        int size = 0;
        for (i2 = 0; i2 < Math.min(bs1.length, bs2.length); ++i2) {
            int n2 = i2;
            bs1[n2] = bs1[n2] & bs2[i2];
            size += Long.bitCount(bs1[i2]);
        }
        while (i2 < bs1.length) {
            bs1[i2] = 0L;
            ++i2;
        }
        return size;
    }

    public static void subtract(long[] bs1, long[] bs2) {
        for (int i2 = 0; i2 < Math.min(bs1.length, bs2.length); ++i2) {
            int n2 = i2;
            bs1[n2] = bs1[n2] & (bs2[i2] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static int removeAll(long[] bs1, long[] bs2) {
        int size = 0;
        for (int i2 = 0; i2 < Math.min(bs1.length, bs2.length); ++i2) {
            int n2 = i2;
            bs1[n2] = bs1[n2] & (bs2[i2] ^ 0xFFFFFFFFFFFFFFFFL);
            size += Long.bitCount(bs1[i2]);
        }
        return size;
    }

    public static void union(long[] bs1, long[] bs2) {
        assert (bs1.length >= bs2.length);
        for (int i2 = 0; i2 < Math.min(bs1.length, bs2.length); ++i2) {
            int n2 = i2;
            bs1[n2] = bs1[n2] | bs2[i2];
        }
    }

    public static int addAll(long[] bs1, long[] bs2) {
        assert (bs1.length >= bs2.length);
        int size = 0;
        for (int i2 = 0; i2 < Math.min(bs1.length, bs2.length); ++i2) {
            int n2 = i2;
            bs1[n2] = bs1[n2] | bs2[i2];
            size += Long.bitCount(bs1[i2]);
        }
        return size;
    }

    public static boolean isDisjoint(long[] bs1, long[] bs2) {
        for (int i2 = 0; i2 < Math.min(bs1.length, bs2.length); ++i2) {
            if ((bs1[i2] & bs2[i2]) == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(long[] bs1, long[] bs2) {
        for (int i2 = 0; i2 < bs2.length; ++i2) {
            if (!(i2 >= bs1.length ? bs2[i2] != 0L : (bs1[i2] & bs2[i2]) != bs2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] bs1, long[] bs2) {
        int i2;
        if (bs1.length == bs2.length) {
            return Arrays.equals(bs1, bs2);
        }
        for (i2 = 0; i2 < Math.min(bs1.length, bs2.length); ++i2) {
            if (bs1[i2] == bs2[i2]) continue;
            return false;
        }
        for (i2 = bs1.length; i2 < bs2.length; ++i2) {
            if (bs1[i2] == 0L) continue;
            return false;
        }
        for (i2 = bs2.length; i2 < bs1.length; ++i2) {
            if (bs2[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(long[] bs) {
        long h2 = 1234L;
        int i2 = bs.length;
        while (--i2 >= 0) {
            h2 ^= bs[i2] * (long)(i2 + 1);
        }
        return (int)(h2 >> 32 ^ h2);
    }

    public static PrimitiveIterator.OfInt iterator(long[] bs) {
        return new BitSetIterator(bs);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(long[] bs) {
        StringBuilder sb = new StringBuilder("[ ");
        int last = -2;
        int rangeBegin = -2;
        BitSetIterator it = new BitSetIterator(bs);
        while (it.hasNext()) {
            int b2 = it.nextInt();
            if (b2 != last + 1) {
                BitSets.appendRange(sb, rangeBegin, last);
                rangeBegin = b2;
            }
            last = b2;
        }
        BitSets.appendRange(sb, rangeBegin, last);
        sb.append(']');
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(Iterable<Integer> bs) {
        StringBuilder sb = new StringBuilder("[ ");
        int last = -2;
        int rangeBegin = -2;
        for (int b2 : bs) {
            if (b2 != last + 1) {
                BitSets.appendRange(sb, rangeBegin, last);
                rangeBegin = b2;
            }
            last = b2;
        }
        BitSets.appendRange(sb, rangeBegin, last);
        sb.append(']');
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static void appendRange(StringBuilder sb, int rangeBegin, int last) {
        if (rangeBegin >= 0 && rangeBegin < last) {
            sb.append(String.format("0x%02x", rangeBegin));
            if (rangeBegin + 1 < last) {
                sb.append("-");
            } else {
                sb.append(" ");
            }
        }
        if (last >= 0) {
            sb.append(String.format("0x%02x ", last));
        }
    }

    private static final class BitSetIterator
    implements PrimitiveIterator.OfInt {
        private final long[] words;
        private int wordIndex = 0;
        private byte bitIndex = 0;
        private long curWord;
        private int last;

        private BitSetIterator(long[] words) {
            this.words = words;
            if (this.hasNext()) {
                this.curWord = words[0];
            }
            this.findNext();
        }

        private void findNext() {
            while (this.curWord == 0L) {
                ++this.wordIndex;
                this.bitIndex = 0;
                if (this.hasNext()) {
                    this.curWord = this.words[this.wordIndex];
                    continue;
                }
                return;
            }
            assert (this.hasNext());
            assert (this.curWord != 0L);
            int trailingZeros = Long.numberOfTrailingZeros(this.curWord);
            this.curWord >>>= trailingZeros;
            this.bitIndex = (byte)(this.bitIndex + trailingZeros);
        }

        @Override
        public boolean hasNext() {
            return this.wordIndex < this.words.length;
        }

        @Override
        public int nextInt() {
            assert (this.hasNext());
            this.last = this.wordIndex * 64 + this.bitIndex;
            this.curWord >>>= 1;
            this.bitIndex = (byte)(this.bitIndex + 1);
            this.findNext();
            return this.last;
        }

        @Override
        public void remove() {
            BitSets.clear(this.words, this.last);
        }
    }
}

